/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindyCsvDataFormat
implements DataFormat {
    private static final transient Log LOG = LogFactory.getLog(BindyCsvDataFormat.class);
    private String[] packages;
    private BindyCsvFactory modelFactory;

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(String ... packages) {
        this.packages = packages;
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyCsvFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList models = (ArrayList)body;
        byte[] bytesCRLF = Converter.getByteReturn(factory.getCarriageReturn());
        for (Map model : models) {
            String result = factory.unbind(model);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyCsvFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream);
        Scanner scanner = new Scanner(in);
        String separator = factory.getSeparator();
        ObjectHelper.notEmpty((String)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
        int count = 0;
        try {
            if (factory.getSkipFirstLine()) {
                scanner.nextLine();
            }
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (ObjectHelper.isEmpty((Object)line)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Counter " + count++ + " : content : " + line));
                }
                Map<String, Object> model = factory.factory();
                String[] tokens = line.split(separator, -1);
                List<String> result = Arrays.asList(tokens);
                if (result.size() == 0 || result.isEmpty()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV !");
                }
                if (result.size() <= 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Size of the record splitted : " + result.size()));
                }
                factory.bind(result, model);
                factory.link(model);
                models.add(model);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Graph of objects created : " + model));
            }
            if (models.size() == 0) {
                throw new IllegalArgumentException("No records have been defined in the CSV !");
            }
            ArrayList<Map<String, Object>> arrayList = models;
            return arrayList;
        }
        finally {
            scanner.close();
            ObjectHelper.close((Closeable)in, (String)"in", (Log)LOG);
        }
    }

    public BindyCsvFactory getFactory(PackageScanClassResolver resolver) throws Exception {
        if (this.modelFactory == null) {
            this.modelFactory = new BindyCsvFactory(resolver, this.packages);
        }
        return this.modelFactory;
    }

    public void setModelFactory(BindyCsvFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }
}

