/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.ConnectionSettingsFactory;
import org.apache.camel.impl.UriEndpointComponent;

public class BeanstalkComponent
extends UriEndpointComponent {
    public static final String DEFAULT_TUBE = "default";
    public static final String COMMAND_BURY = "bury";
    public static final String COMMAND_RELEASE = "release";
    public static final String COMMAND_PUT = "put";
    public static final String COMMAND_TOUCH = "touch";
    public static final String COMMAND_DELETE = "delete";
    public static final String COMMAND_KICK = "kick";
    public static final long DEFAULT_PRIORITY = 1000L;
    public static final int DEFAULT_DELAY = 0;
    public static final int DEFAULT_TIME_TO_RUN = 60;
    private static ConnectionSettingsFactory connectionSettingsFactory = ConnectionSettingsFactory.DEFAULT;

    public BeanstalkComponent() {
        super(BeanstalkEndpoint.class);
    }

    public boolean useRawUri() {
        return true;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new BeanstalkEndpoint(uri, (Component)this, connectionSettingsFactory.parseUri(remaining), remaining);
    }

    public static void setConnectionSettingsFactory(ConnectionSettingsFactory connFactory) {
        connectionSettingsFactory = connFactory;
    }

    public static ConnectionSettingsFactory getConnectionSettingsFactory() {
        return connectionSettingsFactory;
    }
}

