/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.beanio.BeanIOHeader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.BeanReaderErrorHandlerSupport;
import org.beanio.BeanWriter;
import org.beanio.InvalidRecordException;
import org.beanio.StreamFactory;
import org.beanio.UnexpectedRecordException;
import org.beanio.UnidentifiedRecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanIODataFormat
extends ServiceSupport
implements DataFormat,
CamelContextAware {
    private static final String LOG_PREFIX = "BeanIO: ";
    private static final Logger LOG = LoggerFactory.getLogger(BeanIODataFormat.class);
    private transient CamelContext camelContext;
    private transient StreamFactory factory;
    private String streamName;
    private String mapping;
    private boolean ignoreUnidentifiedRecords;
    private boolean ignoreUnexpectedRecords;
    private boolean ignoreInvalidRecords;
    private Charset encoding = Charset.defaultCharset();
    private Properties properties;

    public BeanIODataFormat() {
    }

    public BeanIODataFormat(String mapping, String streamName) {
        this.mapping = mapping;
        this.streamName = streamName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.streamName, (String)"Stream name not configured.");
        if (this.factory == null) {
            this.factory = StreamFactory.newInstance();
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.mapping);
            try {
                if (this.properties != null) {
                    this.factory.load(is, this.properties);
                } else {
                    this.factory.load(is);
                }
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
    }

    protected void doStop() throws Exception {
        this.factory = null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        List<Object> models = this.getModels(exchange, body);
        this.writeModels(stream, models);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.readModels(exchange, stream);
    }

    private List<Object> getModels(Exchange exchange, Object body) {
        ArrayList models = (ArrayList)exchange.getContext().getTypeConverter().convertTo(List.class, body);
        if (models == null) {
            models = new ArrayList();
            Iterator it = ObjectHelper.createIterator((Object)body);
            while (it.hasNext()) {
                models.add(it.next());
            }
        }
        return models;
    }

    private void writeModels(OutputStream stream, List<Object> models) {
        BufferedWriter streamWriter = IOHelper.buffered((Writer)new OutputStreamWriter(stream, this.encoding));
        BeanWriter out = this.factory.createWriter(this.streamName, (Writer)streamWriter);
        for (Object obj : models) {
            out.write(obj);
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readModels(Exchange exchange, InputStream stream) {
        ArrayList<Object> results = new ArrayList<Object>();
        BufferedReader streamReader = IOHelper.buffered((Reader)new InputStreamReader(stream, this.encoding));
        try (BeanReader in = this.factory.createReader(this.streamName, (Reader)streamReader);){
            Object readObject;
            this.registerErrorHandler(in);
            while ((readObject = in.read()) != null) {
                if (readObject instanceof BeanIOHeader) {
                    exchange.getOut().getHeaders().putAll(((BeanIOHeader)readObject).getHeaders());
                }
                results.add(readObject);
            }
        }
        return results;
    }

    private void registerErrorHandler(BeanReader in) {
        in.setErrorHandler((BeanReaderErrorHandler)new BeanReaderErrorHandlerSupport(){

            public void invalidRecord(InvalidRecordException ex) throws Exception {
                String msg = "BeanIO: InvalidRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
                if (!BeanIODataFormat.this.ignoreInvalidRecords) {
                    LOG.warn(msg);
                    throw ex;
                }
                LOG.debug(msg);
            }

            public void unexpectedRecord(UnexpectedRecordException ex) throws Exception {
                String msg = "BeanIO: UnexpectedRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
                if (!BeanIODataFormat.this.ignoreUnexpectedRecords) {
                    LOG.warn(msg);
                    throw ex;
                }
                LOG.debug(msg);
            }

            public void unidentifiedRecord(UnidentifiedRecordException ex) throws Exception {
                String msg = "BeanIO: UnidentifiedRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
                if (!BeanIODataFormat.this.ignoreUnidentifiedRecords) {
                    LOG.warn(msg);
                    throw ex;
                }
                LOG.debug(msg);
            }
        });
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public boolean isIgnoreInvalidRecords() {
        return this.ignoreInvalidRecords;
    }

    public void setIgnoreInvalidRecords(boolean ignoreInvalidRecords) {
        this.ignoreInvalidRecords = ignoreInvalidRecords;
    }

    public boolean isIgnoreUnexpectedRecords() {
        return this.ignoreUnexpectedRecords;
    }

    public void setIgnoreUnexpectedRecords(boolean ignoreUnexpectedRecords) {
        this.ignoreUnexpectedRecords = ignoreUnexpectedRecords;
    }

    public boolean isIgnoreUnidentifiedRecords() {
        return this.ignoreUnidentifiedRecords;
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

