/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class ConstantBeanHolder
implements BeanHolder {
    private final Object bean;
    private final BeanInfo beanInfo;
    private Processor processor;

    public ConstantBeanHolder(Object bean, BeanInfo beanInfo) {
        ObjectHelper.notNull((Object)bean, (String)"bean");
        ObjectHelper.notNull((Object)beanInfo, (String)"beanInfo");
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public ConstantBeanHolder(Object bean, CamelContext context) {
        ObjectHelper.notNull((Object)bean, (String)"bean");
        this.bean = bean;
        this.beanInfo = new BeanInfo(context, bean.getClass());
    }

    public ConstantBeanHolder(Object bean, CamelContext context, ParameterMappingStrategy parameterMappingStrategy) {
        ObjectHelper.notNull((Object)bean, (String)"bean");
        this.bean = bean;
        this.beanInfo = new BeanInfo(context, bean.getClass(), parameterMappingStrategy);
    }

    public String toString() {
        return ObjectHelper.className((Object)this.bean) + "(" + ObjectHelper.getIdentityHashCode((Object)this.bean) + ")";
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            this.processor = (Processor)CamelContextHelper.convertTo((CamelContext)this.beanInfo.getCamelContext(), Processor.class, (Object)this.bean);
        }
        return this.processor;
    }

    @Override
    public boolean supportProcessor() {
        return true;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return null;
    }
}

