/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import jakarta.validation.ConstraintViolation;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.ValidationException;

public class BeanValidationException
extends ValidationException {
    private static final long serialVersionUID = 5767438583860347105L;
    private final Set<ConstraintViolation<Object>> constraintViolations;

    public BeanValidationException(Exchange exchange, Set<ConstraintViolation<Object>> constraintViolations, Object bean) {
        super(exchange, BeanValidationException.buildMessage(constraintViolations, bean));
        this.constraintViolations = constraintViolations;
    }

    protected static String buildMessage(Set<ConstraintViolation<Object>> constraintViolations, Object bean) {
        StringBuilder buffer = new StringBuilder("Validation failed for: ");
        buffer.append(bean);
        buffer.append(" errors: [");
        for (ConstraintViolation<Object> constraintViolation : constraintViolations) {
            buffer.append("property: ").append(constraintViolation.getPropertyPath()).append("; value: ").append(constraintViolation.getInvalidValue()).append("; constraint: ").append(constraintViolation.getMessage()).append("; ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Set<ConstraintViolation<Object>> getConstraintViolations() {
        return this.constraintViolations;
    }
}

