/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.ValidatorFactory;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.validator.BeanValidatorProducer;
import org.apache.camel.component.bean.validator.ValidatorFactories;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.3.0", scheme="bean-validator", title="Bean Validator", syntax="bean-validator:label", producerOnly=true, category={Category.VALIDATION})
public class BeanValidatorEndpoint
extends DefaultEndpoint {
    @UriPath(description="Where label is an arbitrary text value describing the endpoint")
    @Metadata(required=true)
    private String label;
    @UriParam(defaultValue="jakarta.validation.groups.Default")
    private String group;
    @UriParam
    private boolean ignoreXmlConfiguration;
    @UriParam(label="advanced")
    private ValidationProviderResolver validationProviderResolver;
    @UriParam(label="advanced")
    private MessageInterpolator messageInterpolator;
    @UriParam(label="advanced")
    private TraversableResolver traversableResolver;
    @UriParam(label="advanced")
    private ConstraintValidatorFactory constraintValidatorFactory;
    @UriParam(label="advanced")
    private ValidatorFactory validatorFactory;

    public BeanValidatorEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        ValidatorFactory validatorFactory;
        BeanValidatorProducer producer = new BeanValidatorProducer(this);
        if (this.group != null) {
            producer.setGroup(this.getCamelContext().getClassResolver().resolveMandatoryClass(this.group));
        }
        if ((validatorFactory = this.validatorFactory) == null) {
            validatorFactory = ValidatorFactories.buildValidatorFactory(this.getCamelContext(), this.isIgnoreXmlConfiguration(), this.validationProviderResolver, this.messageInterpolator, this.traversableResolver, this.constraintValidatorFactory);
        }
        producer.setValidatorFactory(validatorFactory);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported");
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public void setIgnoreXmlConfiguration(boolean ignoreXmlConfiguration) {
        this.ignoreXmlConfiguration = ignoreXmlConfiguration;
    }

    public ValidationProviderResolver getValidationProviderResolver() {
        return this.validationProviderResolver;
    }

    public void setValidationProviderResolver(ValidationProviderResolver validationProviderResolver) {
        this.validationProviderResolver = validationProviderResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }
}

