/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.bean.validator.ValidationProviderResolverFactory;
import org.apache.camel.support.CamelContextHelper;

public final class ValidatorFactories {
    private ValidatorFactories() {
    }

    public static ValidatorFactory buildValidatorFactory(CamelContext camelContext, boolean ignoreXml, ValidationProviderResolver validationProviderResolver, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        ValidationProviderResolverFactory factory;
        if (validationProviderResolver == null && (factory = (ValidationProviderResolverFactory)CamelContextHelper.findByType((CamelContext)camelContext, ValidationProviderResolverFactory.class)) != null) {
            validationProviderResolver = factory.createValidationProviderResolver(camelContext);
        }
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        if (validationProviderResolver != null) {
            bootstrap.providerResolver(validationProviderResolver);
        }
        Configuration configuration = bootstrap.configure();
        if (messageInterpolator != null) {
            configuration.messageInterpolator(messageInterpolator);
        }
        if (traversableResolver != null) {
            configuration.traversableResolver(traversableResolver);
        }
        if (constraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(constraintValidatorFactory);
        }
        if (ignoreXml) {
            configuration.ignoreXmlConfiguration();
        }
        return configuration.buildValidatorFactory();
    }
}

