/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;

public class Pipeline
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware {
    private final CamelContext camelContext;
    private List<AsyncProcessor> processors;
    private String id;

    public Pipeline(CamelContext camelContext, Collection<Processor> processors) {
        this.camelContext = camelContext;
        this.processors = processors.stream().map(AsyncProcessorConverterHelper::convert).collect(Collectors.toList());
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(camelContext, processors);
    }

    public static Processor newInstance(CamelContext camelContext, Processor ... processors) {
        if (processors == null || processors.length == 0) {
            return null;
        }
        if (processors.length == 1) {
            return processors[0];
        }
        ArrayList<Processor> toBeProcessed = new ArrayList<Processor>(processors.length);
        for (Processor processor : processors) {
            if (processor == null) continue;
            toBeProcessed.add(processor);
        }
        return new Pipeline(camelContext, toBeProcessed);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (exchange.isTransacted()) {
            this.camelContext.getReactiveExecutor().scheduleSync(() -> this.doProcess(exchange, callback, this.processors.iterator(), true), "Step[" + exchange.getExchangeId() + "," + (Object)((Object)this) + "]");
        } else {
            this.camelContext.getReactiveExecutor().scheduleMain(() -> this.doProcess(exchange, callback, this.processors.iterator(), true), "Step[" + exchange.getExchangeId() + "," + (Object)((Object)this) + "]");
        }
        return false;
    }

    protected void doProcess(Exchange exchange, AsyncCallback callback, Iterator<AsyncProcessor> processors, boolean first) {
        if (this.continueRouting(processors, exchange) && (first || PipelineHelper.continueProcessing(exchange, "so breaking out of pipeline", this.log))) {
            ExchangeHelper.prepareOutToIn((Exchange)exchange);
            AsyncProcessor processor = processors.next();
            processor.process(exchange, doneSync -> this.camelContext.getReactiveExecutor().schedule(() -> this.doProcess(exchange, callback, processors, false), "Step[" + exchange.getExchangeId() + "," + (Object)((Object)this) + "]"));
        } else {
            ExchangeHelper.copyResults((Exchange)exchange, (Exchange)exchange);
            this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            this.camelContext.getReactiveExecutor().callback(callback);
        }
    }

    protected boolean continueRouting(Iterator<AsyncProcessor> it, Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop)).booleanValue())) {
            this.log.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange.getExchangeId(), (Object)exchange);
            return false;
        }
        boolean answer = it.hasNext();
        this.log.trace("ExchangeId: {} should continue routing: {}", (Object)exchange.getExchangeId(), (Object)answer);
        return answer;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processors);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processors);
    }

    public String toString() {
        return "Pipeline[" + this.getProcessors() + "]";
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public String getTraceLabel() {
        return "pipeline";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<AsyncProcessor>(this.processors);
    }

    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }
}

