/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.event.DefaultEventFactory;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultManagementStrategy
extends ServiceSupport
implements ManagementStrategy,
CamelContextAware {
    private final List<EventNotifier> eventNotifiers = new CopyOnWriteArrayList<EventNotifier>();
    private EventFactory eventFactory = new DefaultEventFactory();
    private ManagementObjectNameStrategy managementObjectNameStrategy;
    private ManagementObjectStrategy managementObjectStrategy;
    private ManagementAgent managementAgent;
    private CamelContext camelContext;

    public DefaultManagementStrategy() {
    }

    public DefaultManagementStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DefaultManagementStrategy(CamelContext camelContext, ManagementAgent managementAgent) {
        this.camelContext = camelContext;
        this.managementAgent = managementAgent;
    }

    public List<EventNotifier> getEventNotifiers() {
        return this.eventNotifiers;
    }

    public void addEventNotifier(EventNotifier eventNotifier) {
        this.eventNotifiers.add(eventNotifier);
    }

    public boolean removeEventNotifier(EventNotifier eventNotifier) {
        return this.eventNotifiers.remove(eventNotifier);
    }

    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    public ManagementObjectNameStrategy getManagementObjectNameStrategy() {
        if (this.managementObjectNameStrategy == null) {
            this.managementObjectNameStrategy = this.createManagementObjectNameStrategy(null);
        }
        return this.managementObjectNameStrategy;
    }

    public void setManagementObjectNameStrategy(ManagementObjectNameStrategy managementObjectNameStrategy) {
        this.managementObjectNameStrategy = managementObjectNameStrategy;
    }

    public ManagementObjectStrategy getManagementObjectStrategy() {
        if (this.managementObjectStrategy == null) {
            this.managementObjectStrategy = this.createManagementObjectStrategy();
        }
        return this.managementObjectStrategy;
    }

    public void setManagementObjectStrategy(ManagementObjectStrategy managementObjectStrategy) {
        this.managementObjectStrategy = managementObjectStrategy;
    }

    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    public boolean manageProcessor(NamedNode definition) {
        return false;
    }

    public void manageObject(Object managedObject) throws Exception {
    }

    public void unmanageObject(Object managedObject) throws Exception {
    }

    public boolean isManaged(Object managedObject) {
        return false;
    }

    public boolean isManagedName(Object name) {
        return false;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void notify(CamelEvent event) throws Exception {
        if (!this.eventNotifiers.isEmpty()) {
            for (EventNotifier notifier : this.eventNotifiers) {
                if (!notifier.isEnabled(event)) continue;
                notifier.notify(event);
            }
        }
    }

    protected void doStart() throws Exception {
        this.log.info("JMX is disabled");
        this.doStartManagementStrategy();
    }

    protected void doStartManagementStrategy() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        for (EventNotifier notifier : this.eventNotifiers) {
            if (notifier instanceof CamelContextAware) {
                CamelContextAware aware = (CamelContextAware)notifier;
                aware.setCamelContext(this.camelContext);
            }
            ServiceHelper.startService((Object)notifier);
        }
        if (this.managementAgent != null) {
            ServiceHelper.startService((Object)this.managementAgent);
            if (this.managementObjectNameStrategy == null) {
                String domain = this.managementAgent.getMBeanObjectDomainName();
                this.managementObjectNameStrategy = this.createManagementObjectNameStrategy(domain);
            }
        }
        if (this.managementObjectNameStrategy instanceof CamelContextAware) {
            ((CamelContextAware)this.managementObjectNameStrategy).setCamelContext(this.getCamelContext());
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.managementAgent, this.eventNotifiers});
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy(String domain) {
        return null;
    }

    protected ManagementObjectStrategy createManagementObjectStrategy() {
        return null;
    }
}

