/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.AbstractDynamicRegistry;
import org.apache.camel.impl.engine.DefaultTransformerResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.spi.TransformerLoader;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TransformerResolver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformerRegistry
extends AbstractDynamicRegistry<TransformerKey, Transformer>
implements TransformerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTransformerRegistry.class);
    private final Map<TransformerKey, TransformerKey> aliasMap = new ConcurrentHashMap<TransformerKey, TransformerKey>();
    private TransformerResolver<TransformerKey> transformerResolver;

    public DefaultTransformerRegistry(CamelContext context) {
        super(context, CamelContextHelper.getMaximumTransformerCacheSize((CamelContext)context));
    }

    public Transformer resolveTransformer(TransformerKey key) {
        if (DataType.isAnyType((DataType)key.getFrom()) && DataType.isAnyType((DataType)key.getTo())) {
            return null;
        }
        Transformer answer = (Transformer)this.get(this.aliasMap.getOrDefault(key, key));
        if (answer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found transformer {} for key {}", (Object)ObjectHelper.name(answer.getClass()), (Object)key);
            }
            return answer;
        }
        TransformerKey alias = null;
        if (!DataType.isAnyType((DataType)key.getFrom()) && ObjectHelper.isNotEmpty((String)key.getFrom().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getScheme()), key.getTo());
            answer = (Transformer)this.get(alias);
        }
        if (answer == null && ObjectHelper.isNotEmpty((String)key.getTo().getName())) {
            alias = new TransformerKey(key.getFrom(), new DataType(key.getTo().getScheme()));
            answer = (Transformer)this.get(alias);
        }
        if (answer == null && !DataType.isAnyType((DataType)key.getFrom()) && ObjectHelper.isNotEmpty((String)key.getFrom().getName()) && ObjectHelper.isNotEmpty((String)key.getTo().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getScheme()), new DataType(key.getTo().getScheme()));
            answer = (Transformer)this.get(alias);
        }
        if (answer == null && !DataType.isAnyType((DataType)key.getTo()) && (answer = (Transformer)this.get(alias = new TransformerKey(key.getTo()))) == null) {
            alias = new TransformerKey(key.getTo().getScheme());
            answer = (Transformer)this.get(alias);
        }
        if (answer == null && !DataType.isAnyType((DataType)key.getFrom()) && (answer = (Transformer)this.get(alias = new TransformerKey(key.getFrom()))) == null) {
            alias = new TransformerKey(key.getFrom().getScheme());
            answer = (Transformer)this.get(alias);
        }
        if (answer != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found transformer {} for key {} using alias {}", new Object[]{ObjectHelper.name(answer.getClass()), key, alias});
            }
            this.aliasMap.put(key, alias);
            return answer;
        }
        if (!DataType.isJavaType((DataType)key.getTo()) && (answer = this.lazyLoadTransformer(new TransformerKey(key.getTo()))) != null) {
            TransformerKey transformerKey = TransformerKey.createFrom((Transformer)answer);
            this.put(transformerKey, answer);
            if (!key.equals((Object)transformerKey)) {
                this.aliasMap.put(key, transformerKey);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found transformer {} for key {}", (Object)ObjectHelper.name(answer.getClass()), (Object)key);
            }
        }
        return answer;
    }

    private Transformer lazyLoadTransformer(TransformerKey key) {
        Transformer answer = (Transformer)CamelContextHelper.lookup((CamelContext)this.context, (String)key.toString(), Transformer.class);
        if (answer == null) {
            if (this.transformerResolver == null) {
                TransformerResolver resolver = (TransformerResolver)this.context.getRegistry().findSingleByType(TransformerResolver.class);
                if (resolver == null) {
                    resolver = (TransformerResolver)this.context.getCamelContextExtension().getContextPlugin(TransformerResolver.class);
                }
                if (resolver != null) {
                    this.transformerResolver = resolver;
                } else {
                    this.transformerResolver = new DefaultTransformerResolver();
                    LOG.debug("Creating DefaultTransformerResolver");
                }
            }
            answer = this.transformerResolver.resolve((Object)key, this.context);
        }
        return answer;
    }

    @Override
    public Transformer put(TransformerKey key, Transformer obj) {
        ServiceHelper.startService((Service)obj);
        if (obj instanceof TransformerLoader) {
            ((TransformerLoader)obj).load((TransformerRegistry)this);
            return obj;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding transformer for key {}", (Object)key);
        }
        return super.put(key, obj);
    }

    public void init() {
        this.values().forEach((? super T t) -> {
            if (t.getCamelContext() == null) {
                CamelContextAware.trySetCamelContext((Object)t, (CamelContext)this.context);
            }
        });
    }

    @Override
    public boolean isStatic(String scheme) {
        return this.isStatic(new TransformerKey(scheme));
    }

    public boolean isStatic(DataType from, DataType to) {
        return this.isStatic(new TransformerKey(from, to));
    }

    @Override
    public boolean isDynamic(String scheme) {
        return this.isDynamic(new TransformerKey(scheme));
    }

    public boolean isDynamic(DataType from, DataType to) {
        return this.isDynamic(new TransformerKey(from, to));
    }

    @Override
    public String toString() {
        return "TransformerRegistry for " + this.context.getName() + " [capacity: " + this.maxCacheSize + "]";
    }
}

