/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.StreamCache;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.impl.engine.AdviceIterator;
import org.apache.camel.impl.engine.CamelInternalPooledTaskFactory;
import org.apache.camel.impl.engine.CamelInternalTask;
import org.apache.camel.impl.engine.StreamCachingHelper;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelInternalProcessor
extends DelegateAsyncProcessor
implements InternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelInternalProcessor.class);
    private static final Object[] EMPTY_STATES = new Object[0];
    final CamelContext camelContext;
    private final ReactiveExecutor reactiveExecutor;
    private final ShutdownStrategy shutdownStrategy;
    private final List<CamelInternalProcessorAdvice<?>> advices = new ArrayList();
    private byte statefulAdvices;
    private Object[] emptyStatefulStates;
    private PooledObjectFactory<CamelInternalTask> taskFactory;

    public CamelInternalProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.shutdownStrategy = camelContext.getShutdownStrategy();
    }

    public CamelInternalProcessor(CamelContext camelContext, Processor processor) {
        super(processor);
        this.camelContext = camelContext;
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.shutdownStrategy = camelContext.getShutdownStrategy();
    }

    private CamelInternalProcessor(Logger log) {
        this.camelContext = null;
        this.reactiveExecutor = null;
        this.shutdownStrategy = null;
        log.trace("Loaded {}", (Object)AsyncAfterTask.class.getSimpleName());
    }

    protected void doBuild() throws Exception {
        boolean pooled = this.camelContext.getCamelContextExtension().getExchangeFactory().isPooled();
        if (pooled) {
            this.taskFactory = new CamelInternalPooledTaskFactory();
            int capacity = this.camelContext.getCamelContextExtension().getExchangeFactory().getCapacity();
            this.taskFactory.setCapacity(capacity);
            LOG.trace("Using TaskFactory: {}", this.taskFactory);
            this.emptyStatefulStates = new Object[this.statefulAdvices];
        }
        ServiceHelper.buildService((Object[])new Object[]{this.taskFactory, this.processor});
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.taskFactory, this.processor});
    }

    public void addAdvice(CamelInternalProcessorAdvice<?> advice) {
        this.advices.add(advice);
        this.advices.sort((Comparator<CamelInternalProcessorAdvice<?>>)OrderedComparator.get());
        if (advice.hasState()) {
            this.statefulAdvices = (byte)(this.statefulAdvices + 1);
        }
    }

    public <T> T getAdvice(Class<T> type) {
        for (CamelInternalProcessorAdvice<?> task : this.advices) {
            Object advice = CamelInternalProcessor.unwrap(task);
            if (!type.isInstance(advice)) continue;
            return type.cast(advice);
        }
        return null;
    }

    public void addRoutePolicyAdvice(List<RoutePolicy> routePolicyList) {
        this.addAdvice(new RoutePolicyAdvice(routePolicyList));
    }

    public void addRouteInflightRepositoryAdvice(InflightRepository inflightRepository, String routeId) {
        this.addAdvice(new RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), routeId));
    }

    public void addRouteLifecycleAdvice() {
        this.addAdvice(new RouteLifecycleAdvice());
    }

    public void addManagementInterceptStrategy(ManagementInterceptStrategy.InstrumentationProcessor processor) {
        this.addAdvice(CamelInternalProcessor.wrap(processor));
    }

    public void setRouteOnAdvices(Route route) {
        RouteLifecycleAdvice task2;
        RoutePolicyAdvice task = this.getAdvice(RoutePolicyAdvice.class);
        if (task != null) {
            task.setRoute(route);
        }
        if ((task2 = this.getAdvice(RouteLifecycleAdvice.class)) != null) {
            task2.setRoute(route);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback originalCallback) {
        CamelInternalTask afterTask;
        if (this.processor == null || exchange.isRouteStop()) {
            originalCallback.done(true);
            return true;
        }
        if (this.shutdownStrategy.isForceShutdown()) {
            return CamelInternalProcessor.processShutdown(exchange, originalCallback);
        }
        CamelInternalTask camelInternalTask = afterTask = this.taskFactory != null ? (CamelInternalTask)this.taskFactory.acquire() : null;
        if (afterTask == null) {
            states = this.statefulAdvices > 0 ? new Object[this.statefulAdvices] : EMPTY_STATES;
            afterTask = new AsyncAfterTask(states);
        } else {
            states = afterTask.getStates();
        }
        afterTask.prepare(exchange, originalCallback);
        int j = 0;
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice<?> task = this.advices.get(i);
            try {
                Object state = task.before(exchange);
                if (!task.hasState()) continue;
                states[j++] = state;
                continue;
            }
            catch (Exception e) {
                return this.handleException(exchange, originalCallback, e, afterTask);
            }
        }
        if (exchange.isTransacted()) {
            return this.processTransacted(exchange, afterTask);
        }
        return this.processNonTransacted(exchange, afterTask);
    }

    private static boolean processShutdown(Exchange exchange, AsyncCallback originalCallback) {
        String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
        LOG.debug(msg);
        if (exchange.getException() == null) {
            exchange.setException((Throwable)new RejectedExecutionException(msg));
        }
        originalCallback.done(true);
        return true;
    }

    private boolean processNonTransacted(Exchange exchange, CamelInternalTask afterTask) {
        boolean sync;
        AsyncCallback async = this.beforeProcess(exchange, afterTask);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        if (!(sync = this.processor.process(exchange, async))) {
            EventHelper.notifyExchangeAsyncProcessingStartedEvent((CamelContext)this.camelContext, (Exchange)exchange);
        }
        if (LOG.isTraceEnabled()) {
            CamelInternalProcessor.logExchangeContinuity(exchange, sync);
        }
        return sync;
    }

    private static void logExchangeContinuity(Exchange exchange, boolean sync) {
        LOG.trace("Exchange processed and is continued routed {} for exchangeId: {} -> {}", new Object[]{sync ? "synchronously" : "asynchronously", exchange.getExchangeId(), exchange});
    }

    private AsyncCallback beforeProcess(Exchange exchange, CamelInternalTask afterTask) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null && uow.isBeforeAfterProcess()) {
            return uow.beforeProcess((Processor)this.processor, exchange, (AsyncCallback)afterTask);
        }
        return afterTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTransacted(Exchange exchange, CamelInternalTask afterTask) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            afterTask.done(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleException(Exchange exchange, AsyncCallback originalCallback, Exception e, CamelInternalTask afterTask) {
        exchange.setException((Throwable)e);
        try {
            originalCallback.done(true);
        }
        finally {
            if (this.taskFactory != null) {
                this.taskFactory.release((Object)afterTask);
            }
        }
        return true;
    }

    public String toString() {
        return this.processor != null ? this.processor.toString() : super.toString();
    }

    public static <T> CamelInternalProcessorAdvice<T> wrap(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) {
        if (instrumentationProcessor instanceof CamelInternalProcessor) {
            return (CamelInternalProcessorAdvice)instrumentationProcessor;
        }
        return new CamelInternalProcessorAdviceWrapper<T>(instrumentationProcessor);
    }

    public static Object unwrap(CamelInternalProcessorAdvice<?> advice) {
        if (advice instanceof CamelInternalProcessorAdviceWrapper) {
            CamelInternalProcessorAdviceWrapper wrapped = (CamelInternalProcessorAdviceWrapper)advice;
            return wrapped.unwrap();
        }
        return advice;
    }

    private final class AsyncAfterTask
    implements CamelInternalTask {
        private final Object[] states;
        private Exchange exchange;
        private AsyncCallback originalCallback;

        private AsyncAfterTask(Object[] states) {
            this.states = states;
        }

        @Override
        public void prepare(Exchange exchange, AsyncCallback originalCallback) {
            this.exchange = exchange;
            this.originalCallback = originalCallback;
        }

        @Override
        public Object[] getStates() {
            return this.states;
        }

        @Override
        public void reset() {
            System.arraycopy(CamelInternalProcessor.this.emptyStatefulStates, 0, this.states, 0, CamelInternalProcessor.this.statefulAdvices);
            this.exchange = null;
            this.originalCallback = null;
        }

        public void done(boolean doneSync) {
            try {
                AdviceIterator.runAfterTasks(CamelInternalProcessor.this.advices, this.states, this.exchange);
            }
            finally {
                if (this.originalCallback != null) {
                    CamelInternalProcessor.this.reactiveExecutor.schedule((Runnable)this.originalCallback);
                }
                if (CamelInternalProcessor.this.taskFactory != null) {
                    CamelInternalProcessor.this.taskFactory.release((Object)this);
                }
            }
        }
    }

    public static class RoutePolicyAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final List<RoutePolicy> routePolicies;
        private Route route;

        public RoutePolicyAdvice(List<RoutePolicy> routePolicies) {
            this.routePolicies = routePolicies;
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        boolean isRoutePolicyRunAllowed(RoutePolicy policy) {
            if (policy instanceof StatefulService) {
                StatefulService ss = (StatefulService)policy;
                return ss.isRunAllowed();
            }
            return true;
        }

        public Object before(Exchange exchange) throws Exception {
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeBegin(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeBegin on RoutePolicy: {}. This exception will be ignored", (Object)policy, (Object)e);
                }
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (RoutePolicyAdvice.isCamelStopping(exchange.getContext())) {
                return;
            }
            for (RoutePolicy policy : this.routePolicies) {
                try {
                    if (!this.isRoutePolicyRunAllowed(policy)) continue;
                    policy.onExchangeDone(this.route, exchange);
                }
                catch (Exception e) {
                    this.log.warn("Error occurred during onExchangeDone on RoutePolicy: {}. This exception will be ignored", (Object)policy, (Object)e);
                }
            }
        }

        private static boolean isCamelStopping(CamelContext context) {
            if (context != null) {
                return context.isStopping() || context.isStopped();
            }
            return false;
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class RouteInflightRepositoryAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private final InflightRepository inflightRepository;
        private final String id;

        public RouteInflightRepositoryAdvice(InflightRepository inflightRepository, String id) {
            this.inflightRepository = inflightRepository;
            this.id = id;
        }

        public Object before(Exchange exchange) throws Exception {
            this.inflightRepository.add(exchange, this.id);
            return null;
        }

        public void after(Exchange exchange, Object state) throws Exception {
            this.inflightRepository.remove(exchange, this.id);
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class RouteLifecycleAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private Route route;

        public void setRoute(Route route) {
            this.route = route;
        }

        public Object before(Exchange exchange) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.beforeRoute(exchange, this.route);
            }
            return null;
        }

        public void after(Exchange exchange, Object object) throws Exception {
            UnitOfWork uow = exchange.getUnitOfWork();
            if (uow != null) {
                uow.afterRoute(exchange, this.route);
            }
        }

        public boolean hasState() {
            return false;
        }
    }

    record CamelInternalProcessorAdviceWrapper<T>(ManagementInterceptStrategy.InstrumentationProcessor<T> instrumentationProcessor) implements CamelInternalProcessorAdvice<T>,
    Ordered
    {
        ManagementInterceptStrategy.InstrumentationProcessor<T> unwrap() {
            return this.instrumentationProcessor;
        }

        public int getOrder() {
            return this.instrumentationProcessor.getOrder();
        }

        public T before(Exchange exchange) throws Exception {
            return (T)this.instrumentationProcessor.before(exchange);
        }

        public void after(Exchange exchange, T data) throws Exception {
            this.instrumentationProcessor.after(exchange, data);
        }
    }

    private static final class BacklogTraceAdviceEventNotifier
    extends SimpleEventNotifierSupport {
        private final Object dummy = new Object();
        private final ConcurrentMap<Exchange, Object> uris = new ConcurrentHashMap<Exchange, Object>();

        public BacklogTraceAdviceEventNotifier() {
            this.setIgnoreExchangeEvents(false);
            this.setIgnoreExchangeSendingEvents(false);
        }

        public void notify(CamelEvent event) throws Exception {
            CamelEvent.ExchangeSendingEvent ess;
            Exchange e;
            if (event instanceof CamelEvent.ExchangeSendingEvent && this.uris.containsKey(e = (ess = (CamelEvent.ExchangeSendingEvent)event).getExchange())) {
                this.uris.put(e, ess.getEndpoint());
            }
        }

        public void before(Exchange exchange) {
            this.uris.put(exchange, this.dummy);
        }

        public Endpoint after(Exchange exchange) {
            Object o = this.uris.remove(exchange);
            if (o == this.dummy) {
                return null;
            }
            return (Endpoint)o;
        }
    }

    public static class TracingAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private final Tracer tracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final Synchronization tracingAfterRoute;
        private final boolean rest;
        private final boolean template;
        private final boolean skip;

        public TracingAdvice(Tracer tracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.tracer = tracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            TracingAfterRoute tracingAfterRoute = this.tracingAfterRoute = routeDefinition != null ? new TracingAfterRoute(tracer, routeDefinition.getRouteId(), routeDefinition) : null;
            if (routeDefinition != null) {
                this.rest = routeDefinition.isCreatedFromRest();
                this.template = routeDefinition.isCreatedFromTemplate();
            } else {
                this.rest = false;
                this.template = false;
            }
            this.skip = this.rest && !tracer.isTraceRests() ? true : this.template && !tracer.isTraceTemplates();
        }

        public Object before(Exchange exchange) throws Exception {
            if (!this.skip && this.tracer.isEnabled()) {
                boolean contains;
                if (this.tracingAfterRoute != null && !(contains = exchange.getUnitOfWork().containsSynchronization(this.tracingAfterRoute))) {
                    this.tracer.traceBeforeRoute(this.routeDefinition, exchange);
                    exchange.getExchangeExtension().addOnCompletion(this.tracingAfterRoute);
                }
                this.tracer.traceBeforeNode(this.processorDefinition, exchange);
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
            if (!this.skip && this.tracer.isEnabled()) {
                this.tracer.traceAfterNode(this.processorDefinition, exchange);
            }
        }

        public boolean hasState() {
            return false;
        }

        private static final class TracingAfterRoute
        extends SynchronizationAdapter {
            private final Tracer tracer;
            private final String routeId;
            private final NamedRoute node;

            private TracingAfterRoute(Tracer tracer, String routeId, NamedRoute node) {
                this.tracer = tracer;
                this.routeId = routeId;
                this.node = node;
            }

            public SynchronizationRouteAware getRouteSynchronization() {
                return new SynchronizationRouteAware(){

                    public void onBeforeRoute(Route route, Exchange exchange) {
                    }

                    public void onAfterRoute(Route route, Exchange exchange) {
                        if (routeId.equals(route.getId())) {
                            tracer.traceAfterRoute(node, exchange);
                        }
                    }
                };
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                TracingAfterRoute that = (TracingAfterRoute)((Object)o);
                return this.routeId.equals(that.routeId);
            }

            public int hashCode() {
                return Objects.hash(this.routeId);
            }
        }
    }

    public static class DelayerAdvice
    implements CamelInternalProcessorAdvice<Object> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final long delay;

        public DelayerAdvice(long delay) {
            this.delay = delay;
        }

        public Object before(Exchange exchange) throws Exception {
            try {
                this.log.trace("Sleeping for: {} millis", (Object)this.delay);
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.log.debug("Sleep interrupted");
                Thread.currentThread().interrupt();
                throw e;
            }
            return null;
        }

        public void after(Exchange exchange, Object data) throws Exception {
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class StreamCachingAdvice
    implements CamelInternalProcessorAdvice<StreamCache>,
    Ordered {
        private final StreamCachingStrategy strategy;

        public StreamCachingAdvice(StreamCachingStrategy strategy) {
            this.strategy = strategy;
        }

        public StreamCache before(Exchange exchange) throws Exception {
            return StreamCachingHelper.convertToStreamCache(this.strategy, exchange, exchange.getIn());
        }

        public void after(Exchange exchange, StreamCache sc) throws Exception {
            MessageHelper.resetStreamCache((Message)exchange.getMessage());
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }

    public static class NodeHistoryAdvice
    implements CamelInternalProcessorAdvice<String> {
        private final String id;
        private final String label;
        private final String source;

        public NodeHistoryAdvice(NamedNode definition) {
            this.id = definition.getId();
            this.label = definition.getLabel();
            this.source = LoggerHelper.getLineNumberLoggerName((Object)definition);
        }

        public String before(Exchange exchange) throws Exception {
            exchange.getExchangeExtension().setHistoryNodeId(this.id);
            exchange.getExchangeExtension().setHistoryNodeLabel(this.label);
            exchange.getExchangeExtension().setHistoryNodeSource(this.source);
            return null;
        }

        public void after(Exchange exchange, String data) throws Exception {
            exchange.getExchangeExtension().setHistoryNodeId(null);
            exchange.getExchangeExtension().setHistoryNodeLabel(null);
            exchange.getExchangeExtension().setHistoryNodeSource(null);
        }

        public boolean hasState() {
            return false;
        }
    }

    public static class MessageHistoryAdvice
    implements CamelInternalProcessorAdvice<MessageHistory> {
        private final MessageHistoryFactory factory;
        private final NamedNode definition;
        private final String routeId;

        public MessageHistoryAdvice(MessageHistoryFactory factory, NamedNode definition) {
            this.factory = factory;
            this.definition = definition;
            this.routeId = CamelContextHelper.getRouteId((NamedNode)definition);
        }

        public MessageHistory before(Exchange exchange) throws Exception {
            MessageHistory history;
            String targetRouteId = this.routeId;
            if (targetRouteId == null) {
                targetRouteId = ExchangeHelper.getRouteId((Exchange)exchange);
            }
            if ((history = this.factory.newMessageHistory(targetRouteId, this.definition, exchange)) != null) {
                CopyOnWriteArrayList<MessageHistory> list = (CopyOnWriteArrayList<MessageHistory>)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
                if (list == null) {
                    list = new CopyOnWriteArrayList<MessageHistory>();
                    exchange.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, list);
                }
                list.add(history);
            }
            return history;
        }

        public void after(Exchange exchange, MessageHistory history) throws Exception {
            if (history != null) {
                history.nodeProcessingDone();
            }
        }
    }

    public static class ChildUnitOfWorkProcessorAdvice
    extends UnitOfWorkProcessorAdvice {
        private final UnitOfWork parent;

        public ChildUnitOfWorkProcessorAdvice(Route route, CamelContext camelContext, UnitOfWork parent) {
            super(route, camelContext);
            this.parent = parent;
        }

        @Override
        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            return this.parent.createChildUnitOfWork(exchange);
        }
    }

    public static class UnitOfWorkProcessorAdvice
    implements CamelInternalProcessorAdvice<UnitOfWork> {
        private final Route route;
        private String routeId;
        private final UnitOfWorkFactory uowFactory;

        public UnitOfWorkProcessorAdvice(Route route, CamelContext camelContext) {
            this.route = route;
            if (route != null) {
                this.routeId = route.getRouteId();
            }
            this.uowFactory = PluginHelper.getUnitOfWorkFactory((CamelContext)camelContext);
            this.uowFactory.afterPropertiesConfigured(camelContext);
        }

        public UnitOfWork before(Exchange exchange) throws Exception {
            if (this.route != null && exchange.getFromRouteId() == null) {
                if (this.routeId == null) {
                    this.routeId = this.route.getRouteId();
                }
                exchange.getExchangeExtension().setFromRouteId(this.routeId);
            }
            UnitOfWork uow = exchange.getUnitOfWork();
            UnitOfWork created = null;
            if (uow == null) {
                created = this.createUnitOfWork(exchange);
                exchange.getExchangeExtension().setUnitOfWork(created);
                uow = created;
            } else if (uow.onPrepare(exchange)) {
                exchange.getExchangeExtension().setUnitOfWork(uow);
                created = uow;
            }
            if (this.route != null) {
                uow.pushRoute(this.route);
            }
            return created;
        }

        public void after(Exchange exchange, UnitOfWork uow) throws Exception {
            UnitOfWork existing = exchange.getUnitOfWork();
            if (uow != null) {
                UnitOfWorkHelper.doneUow((UnitOfWork)uow, (Exchange)exchange);
            }
            if (this.route != null && existing != null) {
                existing.popRoute();
            }
        }

        protected UnitOfWork createUnitOfWork(Exchange exchange) {
            if (this.uowFactory != null) {
                return this.uowFactory.createUnitOfWork(exchange);
            }
            return PluginHelper.getUnitOfWorkFactory((CamelContext)exchange.getContext()).createUnitOfWork(exchange);
        }
    }

    public static final class DebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch> {
        private final Debugger debugger;
        private final Processor target;
        private final NamedNode definition;

        public DebuggerAdvice(Debugger debugger, Processor target, NamedNode definition) {
            this.debugger = debugger;
            this.target = target;
            this.definition = definition;
        }

        public StopWatch before(Exchange exchange) throws Exception {
            this.debugger.beforeProcess(exchange, this.target, this.definition);
            return new StopWatch();
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            this.debugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
        }
    }

    public static final class BacklogDebuggerAdvice
    implements CamelInternalProcessorAdvice<StopWatch> {
        private final BacklogDebugger backlogDebugger;
        private final Processor target;
        private final NamedNode definition;

        public BacklogDebuggerAdvice(BacklogDebugger backlogDebugger, Processor target, NamedNode definition) {
            this.backlogDebugger = backlogDebugger;
            this.target = target;
            this.definition = definition;
        }

        public StopWatch before(Exchange exchange) throws Exception {
            return this.backlogDebugger.beforeProcess(exchange, this.target, this.definition);
        }

        public void after(Exchange exchange, StopWatch stopWatch) throws Exception {
            if (stopWatch != null) {
                this.backlogDebugger.afterProcess(exchange, this.target, this.definition, stopWatch.taken());
            }
        }
    }

    public static final class BacklogTracerAdvice
    implements CamelInternalProcessorAdvice<DefaultBacklogTracerEventMessage> {
        private final BacklogTraceAdviceEventNotifier notifier;
        private final CamelContext camelContext;
        private final BacklogTracer backlogTracer;
        private final NamedNode processorDefinition;
        private final NamedRoute routeDefinition;
        private final boolean first;
        private final boolean rest;
        private final boolean template;
        private final boolean skip;

        public BacklogTracerAdvice(CamelContext camelContext, BacklogTracer backlogTracer, NamedNode processorDefinition, NamedRoute routeDefinition, boolean first) {
            this.camelContext = camelContext;
            this.backlogTracer = backlogTracer;
            this.processorDefinition = processorDefinition;
            this.routeDefinition = routeDefinition;
            this.first = first;
            if (routeDefinition != null) {
                this.rest = routeDefinition.isCreatedFromRest();
                this.template = routeDefinition.isCreatedFromTemplate();
            } else {
                this.rest = false;
                this.template = false;
            }
            this.skip = this.rest && !backlogTracer.isTraceRests() ? true : this.template && !backlogTracer.isTraceTemplates();
            this.notifier = this.getOrCreateEventNotifier(camelContext);
        }

        private BacklogTraceAdviceEventNotifier getOrCreateEventNotifier(CamelContext camelContext) {
            for (EventNotifier en : camelContext.getManagementStrategy().getEventNotifiers()) {
                if (!(en instanceof BacklogTraceAdviceEventNotifier)) continue;
                return (BacklogTraceAdviceEventNotifier)en;
            }
            BacklogTraceAdviceEventNotifier answer = new BacklogTraceAdviceEventNotifier();
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)answer);
            return answer;
        }

        public DefaultBacklogTracerEventMessage before(Exchange exchange) throws Exception {
            if (!this.skip && this.backlogTracer.shouldTrace(this.processorDefinition, exchange)) {
                String source;
                String routeId;
                this.notifier.before(exchange);
                long timestamp = System.currentTimeMillis();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                boolean includeExchangeProperties = this.backlogTracer.isIncludeExchangeProperties();
                String messageAsXml = MessageHelper.dumpAsXml((Message)exchange.getIn(), (boolean)includeExchangeProperties, (boolean)true, (int)4, (boolean)true, (boolean)this.backlogTracer.isBodyIncludeStreams(), (boolean)this.backlogTracer.isBodyIncludeFiles(), (int)this.backlogTracer.getBodyMaxChars());
                String messageAsJSon = MessageHelper.dumpAsJSon((Message)exchange.getIn(), (boolean)includeExchangeProperties, (boolean)true, (int)4, (boolean)true, (boolean)this.backlogTracer.isBodyIncludeStreams(), (boolean)this.backlogTracer.isBodyIncludeFiles(), (int)this.backlogTracer.getBodyMaxChars(), (boolean)true);
                String string = routeId = this.routeDefinition != null ? this.routeDefinition.getRouteId() : null;
                if (this.first) {
                    source = LoggerHelper.getLineNumberLoggerName((Object)this.routeDefinition);
                    long created = exchange.getClock().getCreated();
                    DefaultBacklogTracerEventMessage pseudoFirst = new DefaultBacklogTracerEventMessage(true, false, this.backlogTracer.incrementTraceCounter(), created, source, routeId, null, exchangeId, this.rest, this.template, messageAsXml, messageAsJSon);
                    this.backlogTracer.traceEvent(pseudoFirst);
                    exchange.getExchangeExtension().addOnCompletion((Synchronization)this.createOnCompletion(source, pseudoFirst));
                }
                source = LoggerHelper.getLineNumberLoggerName((Object)this.processorDefinition);
                DefaultBacklogTracerEventMessage event = new DefaultBacklogTracerEventMessage(false, false, this.backlogTracer.incrementTraceCounter(), timestamp, source, routeId, toNode, exchangeId, this.rest, this.template, messageAsXml, messageAsJSon);
                this.backlogTracer.traceEvent(event);
                return event;
            }
            return null;
        }

        private SynchronizationAdapter createOnCompletion(final String source, final DefaultBacklogTracerEventMessage pseudoFirst) {
            return new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    String routeId = routeDefinition != null ? routeDefinition.getRouteId() : null;
                    String exchangeId = exchange.getExchangeId();
                    boolean includeExchangeProperties = backlogTracer.isIncludeExchangeProperties();
                    long created = exchange.getClock().getCreated();
                    String messageAsXml = MessageHelper.dumpAsXml((Message)exchange.getIn(), (boolean)includeExchangeProperties, (boolean)true, (int)4, (boolean)true, (boolean)backlogTracer.isBodyIncludeStreams(), (boolean)backlogTracer.isBodyIncludeFiles(), (int)backlogTracer.getBodyMaxChars());
                    String messageAsJSon = MessageHelper.dumpAsJSon((Message)exchange.getIn(), (boolean)includeExchangeProperties, (boolean)true, (int)4, (boolean)true, (boolean)backlogTracer.isBodyIncludeStreams(), (boolean)backlogTracer.isBodyIncludeFiles(), (int)backlogTracer.getBodyMaxChars(), (boolean)true);
                    DefaultBacklogTracerEventMessage pseudoLast = new DefaultBacklogTracerEventMessage(false, true, backlogTracer.incrementTraceCounter(), created, source, routeId, null, exchangeId, rest, template, messageAsXml, messageAsJSon);
                    backlogTracer.traceEvent(pseudoLast);
                    this.doneProcessing(exchange, pseudoLast);
                    this.doneProcessing(exchange, pseudoFirst);
                    pseudoLast.setElapsed(pseudoFirst.getElapsed());
                    pseudoFirst.setElapsed(0L);
                }
            };
        }

        public void after(Exchange exchange, DefaultBacklogTracerEventMessage data) throws Exception {
            if (data != null) {
                this.doneProcessing(exchange, data);
            }
        }

        private void doneProcessing(Exchange exchange, DefaultBacklogTracerEventMessage data) {
            Exception e;
            data.doneProcessing();
            String uri = null;
            Endpoint endpoint = this.notifier.after(exchange);
            if (endpoint != null) {
                uri = endpoint.getEndpointUri();
            } else if ((data.isFirst() || data.isLast()) && data.getToNode() == null && this.routeDefinition != null) {
                Route route = this.camelContext.getRoute(this.routeDefinition.getRouteId());
                uri = route != null && route.getConsumer() != null ? route.getConsumer().getEndpoint().getEndpointUri() : this.routeDefinition.getEndpointUrl();
            }
            if (uri != null) {
                data.setEndpointUri(uri);
            }
            if (!data.isFirst() && this.backlogTracer.isIncludeException() && (e = exchange.getException()) != null) {
                String xml = MessageHelper.dumpExceptionAsXML((Throwable)e, (int)4);
                data.setExceptionAsXml(xml);
                String json = MessageHelper.dumpExceptionAsJSon((Throwable)e, (int)4, (boolean)true);
                data.setExceptionAsJSon(json);
            }
        }

        public boolean hasState() {
            return true;
        }
    }
}

