/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePackageScanResolver
extends ServiceSupport
implements CamelContextAware {
    protected String[] acceptableSchemes = new String[0];
    private final Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private CamelContext camelContext;

    public BasePackageScanResolver() {
        this.initialize();
    }

    public void initialize() {
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.classLoaders.add(ccl);
            }
        }
        catch (Exception e) {
            this.logger().warn("Cannot add ContextClassLoader from current thread due {}. This exception will be ignored.", (Object)e.getMessage());
        }
        this.classLoaders.add(BasePackageScanResolver.class.getClassLoader());
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.camelContext != null && this.camelContext.getApplicationContextClassLoader() != null) {
            this.addClassLoader(this.camelContext.getApplicationContextClassLoader());
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void setAcceptableSchemes(String schemes) {
        if (schemes != null) {
            this.acceptableSchemes = schemes.split(";");
        }
    }

    protected boolean isAcceptableScheme(String urlPath) {
        if (urlPath != null) {
            for (String scheme : this.acceptableSchemes) {
                if (!urlPath.startsWith(scheme)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(new LinkedHashSet<ClassLoader>(this.classLoaders));
    }

    protected URL customResourceLocator(URL url) throws IOException {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.logger().trace("Getting resource URL for package: {} with classloader: {}", packageName, (Object)loader);
        if (!((String)packageName).isEmpty() && !((String)packageName).endsWith("/")) {
            packageName = (String)packageName + "/";
        }
        return loader.getResources((String)packageName);
    }

    protected String parseUrlPath(URL url) {
        String urlPath = url.getFile();
        urlPath = URLDecoder.decode(urlPath, StandardCharsets.UTF_8);
        if (this.logger().isTraceEnabled()) {
            this.logger().trace("Decoded urlPath: {} with protocol: {}", (Object)urlPath, (Object)url.getProtocol());
        }
        if (urlPath.startsWith("file:")) {
            try {
                urlPath = new URI(url.getFile()).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
        }
        if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
            this.logger().trace("Skipping OSGi bundle: {}", (Object)url);
            return null;
        }
        if (url.toString().startsWith("bundleresource:") || urlPath.startsWith("bundleresource:")) {
            this.logger().trace("Skipping bundleresource: {}", (Object)url);
            return null;
        }
        if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.indexOf(33));
        }
        return urlPath;
    }

    protected Enumeration<URL> getUrls(String packageName, ClassLoader loader) {
        Enumeration<URL> urls;
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.logger().trace("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.logger().warn("Cannot read package: {}", (Object)packageName, (Object)ioe);
            return null;
        }
        return urls;
    }

    private Logger logger() {
        class Holder {
            static final Logger LOG = LoggerFactory.getLogger(BasePackageScanResolver.class);

            Holder() {
            }
        }
        return Holder.LOG;
    }
}

