/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.support.DefaultMessageHistory;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;

@ManagedResource(description="Managed MessageHistoryFactory")
public class DefaultMessageHistoryFactory
extends ServiceSupport
implements MessageHistoryFactory {
    private CamelContext camelContext;
    private boolean copyMessage;
    private String nodePattern;
    private volatile String[] nodePatternParts;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode node, long timestamp, Exchange exchange) {
        if (this.nodePatternParts != null) {
            String name = node.getShortName();
            for (String part : this.nodePatternParts) {
                boolean match = PatternHelper.matchPattern((String)name, (String)part);
                if (match) continue;
                return null;
            }
        }
        Message msg = null;
        if (this.copyMessage) {
            msg = exchange.getMessage().copy();
        }
        return new DefaultMessageHistory(routeId, node, timestamp, msg);
    }

    @ManagedAttribute(description="Whether message history is enabled")
    public boolean isEnabled() {
        return this.camelContext != null ? this.camelContext.isMessageHistory() : false;
    }

    @ManagedAttribute(description="Whether a copy of the message is included in the message history")
    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    @ManagedAttribute(description="Whether a copy of the message is included in the message history")
    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    @ManagedAttribute(description="Pattern to filter EIPs")
    public String getNodePattern() {
        return this.nodePattern;
    }

    @ManagedAttribute(description="Pattern to filter EIPs")
    public void setNodePattern(String nodePattern) {
        this.nodePattern = nodePattern;
        if (nodePattern != null) {
            this.nodePatternParts = nodePattern.split(",");
        }
    }
}

