/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.apache.camel.bam.EntityManagerCallback;
import org.apache.camel.bam.EntityManagers;

public class EntityManagerTemplate {
    private final EntityManagerFactory entityManagerFactory;

    public EntityManagerTemplate(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(EntityManagerCallback<T> entityManagerCallback) {
        EntityManager entityManager = null;
        try {
            entityManager = EntityManagers.resolveEntityManager(this.entityManagerFactory);
            T t = entityManagerCallback.execute(entityManager);
            return t;
        }
        finally {
            EntityManagers.closeNonTransactionalEntityManager(entityManager);
        }
    }

    public void persist(final Object entity) {
        this.execute(new EntityManagerCallback<Object>(){

            @Override
            public Object execute(EntityManager entityManager) {
                entityManager.persist(entity);
                return null;
            }
        });
    }

    public void flush() {
        this.execute(new EntityManagerCallback<Object>(){

            @Override
            public Object execute(EntityManager entityManager) {
                entityManager.flush();
                return null;
            }
        });
    }

    public <T> List<T> find(final Class<T> entity, final String query, final Map<String, Object> parameters) {
        return (List)this.execute(new EntityManagerCallback<List<T>>(){

            @Override
            public List<T> execute(EntityManager entityManager) {
                TypedQuery typedQuery = entityManager.createQuery(query, entity);
                for (Map.Entry parameter : parameters.entrySet()) {
                    typedQuery.setParameter((String)parameter.getKey(), parameter.getValue());
                }
                return typedQuery.getResultList();
            }
        });
    }
}

