/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.Date;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.bam.ActivityLifecycle;
import org.apache.camel.bam.ProcessBuilder;
import org.apache.camel.bam.TimeExpression;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.rules.ActivityRules;

public class ActivityBuilder {
    private final ProcessBuilder processBuilder;
    private final Endpoint endpoint;
    private final ActivityRules activityRules;
    private Expression correlationExpression;
    private volatile Processor processor;

    public ActivityBuilder(ProcessBuilder processBuilder, Endpoint endpoint) {
        this.processBuilder = processBuilder;
        this.endpoint = endpoint;
        this.activityRules = new ActivityRules(processBuilder);
        this.activityRules.setActivityName(endpoint.getEndpointUri());
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor createProcessor() throws Exception {
        return this.processBuilder.createActivityProcessor(this);
    }

    public synchronized Processor getProcessor() throws Exception {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        if (this.processor == null) {
            throw new IllegalArgumentException("No processor created for ActivityBuilder: " + this);
        }
        return this.processor;
    }

    public ActivityBuilder correlate(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
        return this;
    }

    public ActivityBuilder name(String name) {
        this.activityRules.setActivityName(name);
        return this;
    }

    public TimeExpression starts() {
        return new TimeExpression(this, ActivityLifecycle.Started){

            @Override
            public Date evaluate(ProcessInstance instance, ActivityState state) {
                return state.getTimeStarted();
            }
        };
    }

    public TimeExpression completes() {
        return new TimeExpression(this, ActivityLifecycle.Completed){

            @Override
            public Date evaluate(ProcessInstance instance, ActivityState state) {
                return state.getTimeCompleted();
            }
        };
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    public ActivityRules getActivityRules() {
        return this.activityRules;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }
}

