/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueMessage;
import com.microsoft.azure.storage.queue.MessageUpdateFields;
import com.microsoft.azure.storage.queue.QueueListingDetails;
import java.util.EnumSet;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.common.ExchangeUtil;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceEndpoint;
import org.apache.camel.component.azure.queue.QueueServiceOperations;
import org.apache.camel.component.azure.queue.QueueServiceRequestOptions;
import org.apache.camel.component.azure.queue.QueueServiceUtil;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueServiceProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(QueueServiceProducer.class);

    public QueueServiceProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        QueueServiceOperations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = QueueServiceOperations.listQueues;
        } else {
            switch (operation) {
                case retrieveMessage: {
                    this.retrieveMessage(exchange);
                    break;
                }
                case peekMessage: {
                    this.peekMessage(exchange);
                    break;
                }
                case createQueue: {
                    this.createQueue(exchange);
                    break;
                }
                case deleteQueue: {
                    this.deleteQueue(exchange);
                    break;
                }
                case addMessage: {
                    this.addMessage(exchange);
                    break;
                }
                case updateMessage: {
                    this.updateMessage(exchange);
                    break;
                }
                case deleteMessage: {
                    this.deleteMessage(exchange);
                    break;
                }
                case listQueues: {
                    this.listQueues(exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    private void listQueues(Exchange exchange) throws Exception {
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        QueueListingDetails details = (QueueListingDetails)exchange.getIn().getHeader("QueueListingDetails");
        if (details == null) {
            details = QueueListingDetails.ALL;
        }
        Iterable list = client.getServiceClient().listQueues(this.getConfiguration().getQueuePrefix(), details, opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)list);
    }

    private void createQueue(Exchange exchange) throws Exception {
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        this.doCreateQueue(client, opts, exchange);
    }

    private void doCreateQueue(CloudQueue client, QueueServiceRequestOptions opts, Exchange exchange) throws Exception {
        LOG.trace("Creating the queue [{}] from exchange [{}]...", (Object)this.getConfiguration().getQueueName(), (Object)exchange);
        client.createIfNotExists(opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setHeader("QueueCreated", (Object)Boolean.TRUE);
    }

    private void deleteQueue(Exchange exchange) throws Exception {
        LOG.trace("Deleting the queue [{}] from exchange [{}]...", (Object)this.getConfiguration().getQueueName(), (Object)exchange);
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        client.delete(opts.getRequestOpts(), opts.getOpContext());
    }

    private void addMessage(Exchange exchange) throws Exception {
        LOG.trace("Putting the message into the queue [{}] from exchange [{}]...", (Object)this.getConfiguration().getQueueName(), (Object)exchange);
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        Boolean queueCreated = (Boolean)exchange.getIn().getHeader("QueueCreated", Boolean.class);
        if (Boolean.TRUE != queueCreated) {
            this.doCreateQueue(client, opts, exchange);
        }
        CloudQueueMessage message = this.getCloudQueueMessage(exchange);
        client.addMessage(message, this.getConfiguration().getMessageTimeToLive(), this.getConfiguration().getMessageVisibilityDelay(), opts.getRequestOpts(), opts.getOpContext());
    }

    private void updateMessage(Exchange exchange) throws Exception {
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        CloudQueueMessage message = this.getCloudQueueMessage(exchange);
        LOG.trace("Updating the message in the queue [{}] from exchange [{}]...", (Object)this.getConfiguration().getQueueName(), (Object)exchange);
        EnumSet<MessageUpdateFields> fields = null;
        Object fieldsObject = exchange.getIn().getHeader("QueueMessageUpdateFields");
        if (fieldsObject instanceof EnumSet) {
            EnumSet<MessageUpdateFields> theFields;
            fields = theFields = (EnumSet<MessageUpdateFields>)fieldsObject;
        } else if (fieldsObject instanceof MessageUpdateFields) {
            fields = EnumSet.of((MessageUpdateFields)fieldsObject);
        }
        client.updateMessage(message, this.getConfiguration().getMessageVisibilityDelay(), fields, opts.getRequestOpts(), opts.getOpContext());
    }

    private void deleteMessage(Exchange exchange) throws Exception {
        LOG.trace("Deleting the message from the queue [{}] from exchange [{}]...", (Object)this.getConfiguration().getQueueName(), (Object)exchange);
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        CloudQueueMessage message = this.getCloudQueueMessage(exchange);
        client.deleteMessage(message, opts.getRequestOpts(), opts.getOpContext());
    }

    private void retrieveMessage(Exchange exchange) throws Exception {
        QueueServiceUtil.retrieveMessage(exchange, this.getConfiguration());
    }

    private void peekMessage(Exchange exchange) throws Exception {
        CloudQueue client = QueueServiceUtil.createQueueClient(this.getConfiguration());
        QueueServiceRequestOptions opts = QueueServiceUtil.getRequestOptions(exchange);
        CloudQueueMessage message = client.peekMessage(opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)message);
    }

    private CloudQueueMessage getCloudQueueMessage(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getMandatoryBody();
        CloudQueueMessage message = null;
        if (body instanceof CloudQueueMessage) {
            message = (CloudQueueMessage)body;
        } else if (body instanceof String) {
            message = new CloudQueueMessage((String)body);
        }
        if (message == null) {
            throw new IllegalArgumentException("Unsupported queue message type:" + body.getClass().getName());
        }
        return message;
    }

    private QueueServiceOperations determineOperation(Exchange exchange) {
        QueueServiceOperations operation = (QueueServiceOperations)((Object)exchange.getIn().getHeader("operation", QueueServiceOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected QueueServiceConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "StorageQueueProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public QueueServiceEndpoint getEndpoint() {
        return (QueueServiceEndpoint)super.getEndpoint();
    }
}

