/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.storage.queue.QueueComponent;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class QueueComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private QueueConfiguration getOrCreateConfiguration(QueueComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new QueueConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QueueComponent target = (QueueComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)QueueComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((QueueConfiguration)QueueComponentConfigurer.property((CamelContext)camelContext, QueueConfiguration.class, (Object)value));
                return true;
            }
            case "createqueue": 
            case "createQueue": {
                this.getOrCreateConfiguration(target).setCreateQueue((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials((StorageSharedKeyCredential)QueueComponentConfigurer.property((CamelContext)camelContext, StorageSharedKeyCredential.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)QueueComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessages": 
            case "maxMessages": {
                this.getOrCreateConfiguration(target).setMaxMessages((Integer)QueueComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messageid": 
            case "messageId": {
                this.getOrCreateConfiguration(target).setMessageId((String)QueueComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((QueueOperationDefinition)((Object)QueueComponentConfigurer.property((CamelContext)camelContext, QueueOperationDefinition.class, (Object)value)));
                return true;
            }
            case "popreceipt": 
            case "popReceipt": {
                this.getOrCreateConfiguration(target).setPopReceipt((String)QueueComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                this.getOrCreateConfiguration(target).setServiceClient((QueueServiceClient)QueueComponentConfigurer.property((CamelContext)camelContext, QueueServiceClient.class, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                this.getOrCreateConfiguration(target).setTimeToLive((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                this.getOrCreateConfiguration(target).setVisibilityTimeout((Duration)QueueComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"serviceClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return QueueConfiguration.class;
            }
            case "createqueue": 
            case "createQueue": {
                return Boolean.TYPE;
            }
            case "credentials": {
                return StorageSharedKeyCredential.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxmessages": 
            case "maxMessages": {
                return Integer.class;
            }
            case "messageid": 
            case "messageId": {
                return String.class;
            }
            case "operation": {
                return QueueOperationDefinition.class;
            }
            case "popreceipt": 
            case "popReceipt": {
                return String.class;
            }
            case "serviceclient": 
            case "serviceClient": {
                return QueueServiceClient.class;
            }
            case "timetolive": 
            case "timeToLive": {
                return Duration.class;
            }
            case "timeout": {
                return Duration.class;
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                return Duration.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QueueComponent target = (QueueComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "createqueue": 
            case "createQueue": {
                return this.getOrCreateConfiguration(target).isCreateQueue();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessages": 
            case "maxMessages": {
                return this.getOrCreateConfiguration(target).getMaxMessages();
            }
            case "messageid": 
            case "messageId": {
                return this.getOrCreateConfiguration(target).getMessageId();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "popreceipt": 
            case "popReceipt": {
                return this.getOrCreateConfiguration(target).getPopReceipt();
            }
            case "serviceclient": 
            case "serviceClient": {
                return this.getOrCreateConfiguration(target).getServiceClient();
            }
            case "timetolive": 
            case "timeToLive": {
                return this.getOrCreateConfiguration(target).getTimeToLive();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
            case "visibilitytimeout": 
            case "visibilityTimeout": {
                return this.getOrCreateConfiguration(target).getVisibilityTimeout();
            }
        }
        return null;
    }
}

