/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.storage.file.datalake.models.AccessTier;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.time.Duration;
import java.util.Map;

public class FileCommonRequestOptions {
    private final PathHttpHeaders pathHttpHeaders;
    private final Map<String, String> metadata;
    private final AccessTier accessTier;
    private final DataLakeRequestConditions requestConditions;
    private final byte[] contentMD5;
    private final Duration timeout;

    public FileCommonRequestOptions(PathHttpHeaders pathHttpHeaders, Map<String, String> metadata, AccessTier accessTier, DataLakeRequestConditions requestConditions, byte[] contentMD5, Duration timeout) {
        this.pathHttpHeaders = pathHttpHeaders;
        this.metadata = metadata;
        this.accessTier = accessTier;
        this.requestConditions = requestConditions;
        this.contentMD5 = contentMD5;
        this.timeout = timeout;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public <T extends DataLakeRequestConditions> T getRequestConditions() {
        if (this.requestConditions == null) {
            return null;
        }
        return (T)this.requestConditions;
    }

    public PathHttpHeaders getPathHttpHeaders() {
        return this.pathHttpHeaders;
    }

    public byte[] getContentMD5() {
        return this.contentMD5;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getLeaseId() {
        if (this.requestConditions == null) {
            return null;
        }
        return this.requestConditions.getLeaseId();
    }
}

