/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import java.util.Locale;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataLakeClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeClientFactory.class);
    private static final String SERVICE_URI_SEGMENT = ".dfs.core.windows.net";

    private DataLakeClientFactory() {
    }

    public static DataLakeServiceClient createDataLakeServiceClient(DataLakeConfiguration configuration) {
        DataLakeServiceClient client = configuration.getServiceClient() != null ? configuration.getServiceClient() : (configuration.getAccountKey() != null || configuration.getSharedKeyCredential() != null ? DataLakeClientFactory.createDataLakeServiceClientWithSharedKey(configuration) : DataLakeClientFactory.createDataLakeServiceClientWithClientSecret(configuration));
        return client;
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithSharedKey(DataLakeConfiguration configuration) {
        StorageSharedKeyCredential sharedKeyCredential = configuration.getSharedKeyCredential();
        if (sharedKeyCredential == null) {
            sharedKeyCredential = new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccountKey());
        }
        return new DataLakeServiceClientBuilder().credential(sharedKeyCredential).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static DataLakeServiceClient createDataLakeServiceClientWithClientSecret(DataLakeConfiguration configuration) {
        ClientSecretCredential clientSecretCredential = configuration.getClientSecretCredential();
        if (clientSecretCredential == null) {
            clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(configuration.getClientId())).clientSecret(configuration.getClientSecret()).tenantId(configuration.getTenantId())).build();
        }
        return new DataLakeServiceClientBuilder().credential((TokenCredential)clientSecretCredential).endpoint(DataLakeClientFactory.buildAzureUri(configuration)).buildClient();
    }

    private static String buildAzureUri(DataLakeConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.dfs.core.windows.net", DataLakeClientFactory.getAccountName(configuration));
    }

    private static String getAccountName(DataLakeConfiguration configuration) {
        String accountName = ObjectHelper.isNotEmpty((Object)configuration.getSharedKeyCredential()) ? configuration.getSharedKeyCredential().getAccountName() : configuration.getAccountName();
        return accountName;
    }
}

