/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.changefeed.BlobChangefeedClient;
import com.azure.storage.blob.changefeed.BlobChangefeedClientBuilder;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.client.BlobClientWrapper;
import org.apache.camel.component.azure.storage.blob.client.BlobServiceClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobChangeFeedOperations;
import org.apache.camel.component.azure.storage.blob.operations.BlobContainerOperations;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperations;
import org.apache.camel.component.azure.storage.blob.operations.BlobServiceOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class BlobProducer
extends DefaultProducer {
    private final BlobConfiguration configuration = this.getEndpoint().getConfiguration();
    private final BlobConfigurationOptionsProxy configurationProxy;
    private final BlobServiceOperations blobServiceOperations;
    private final BlobServiceClientWrapper blobServiceClientWrapper = new BlobServiceClientWrapper(this.getEndpoint().getBlobServiceClient());

    public BlobProducer(Endpoint endpoint) {
        super(endpoint);
        this.blobServiceOperations = new BlobServiceOperations(this.configuration, this.blobServiceClientWrapper);
        this.configurationProxy = new BlobConfigurationOptionsProxy(this.configuration);
    }

    public void process(Exchange exchange) throws Exception {
        BlobOperationsDefinition operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = BlobOperationsDefinition.listBlobContainers;
        }
        switch (operation) {
            case listBlobContainers: {
                this.setResponse(exchange, this.blobServiceOperations.listBlobContainers(exchange));
                break;
            }
            case createBlobContainer: {
                this.setResponse(exchange, this.getContainerOperations(exchange).createContainer(exchange));
                break;
            }
            case deleteBlobContainer: {
                this.setResponse(exchange, this.getContainerOperations(exchange).deleteContainer(exchange));
                break;
            }
            case listBlobs: {
                this.setResponse(exchange, this.getContainerOperations(exchange).listBlobs(exchange));
                break;
            }
            case getBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).getBlob(exchange));
                break;
            }
            case deleteBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).deleteBlob(exchange));
                break;
            }
            case downloadBlobToFile: {
                this.setResponse(exchange, this.getBlobOperations(exchange).downloadBlobToFile(exchange));
                break;
            }
            case downloadLink: {
                this.setResponse(exchange, this.getBlobOperations(exchange).downloadLink(exchange));
                break;
            }
            case uploadBlockBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).uploadBlockBlob(exchange));
                break;
            }
            case stageBlockBlobList: {
                this.setResponse(exchange, this.getBlobOperations(exchange).stageBlockBlobList(exchange));
                break;
            }
            case commitBlobBlockList: {
                this.setResponse(exchange, this.getBlobOperations(exchange).commitBlobBlockList(exchange));
                break;
            }
            case getBlobBlockList: {
                this.setResponse(exchange, this.getBlobOperations(exchange).getBlobBlockList(exchange));
                break;
            }
            case createAppendBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).createAppendBlob(exchange));
                break;
            }
            case commitAppendBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).commitAppendBlob(exchange));
                break;
            }
            case createPageBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).createPageBlob(exchange));
                break;
            }
            case uploadPageBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).uploadPageBlob(exchange));
                break;
            }
            case resizePageBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).resizePageBlob(exchange));
                break;
            }
            case clearPageBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).clearPageBlob(exchange));
                break;
            }
            case getPageBlobRanges: {
                this.setResponse(exchange, this.getBlobOperations(exchange).getPageBlobRanges(exchange));
                break;
            }
            case getChangeFeed: {
                this.setResponse(exchange, this.getBlobChangeFeedOperations().getEvents(exchange));
                break;
            }
            case copyBlob: {
                this.setResponse(exchange, this.getBlobOperations(exchange).copyBlob(exchange));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void setResponse(Exchange exchange, BlobOperationResponse blobOperationResponse) {
        exchange.getMessage().setBody(blobOperationResponse.getBody());
        exchange.getMessage().getHeaders().putAll(blobOperationResponse.getHeaders());
    }

    public BlobEndpoint getEndpoint() {
        return (BlobEndpoint)super.getEndpoint();
    }

    private BlobOperationsDefinition determineOperation(Exchange exchange) {
        return this.configurationProxy.getOperation(exchange);
    }

    private BlobContainerOperations getContainerOperations(Exchange exchange) {
        return new BlobContainerOperations(this.configuration, this.blobServiceClientWrapper.getBlobContainerClientWrapper(this.determineContainerName(exchange)));
    }

    private BlobOperations getBlobOperations(Exchange exchange) {
        BlobClientWrapper clientWrapper = this.blobServiceClientWrapper.getBlobContainerClientWrapper(this.determineContainerName(exchange)).getBlobClientWrapper(this.determineBlobName(exchange));
        return new BlobOperations(this.configuration, clientWrapper);
    }

    private BlobChangeFeedOperations getBlobChangeFeedOperations() {
        BlobChangefeedClient changefeedClient = new BlobChangefeedClientBuilder(this.getEndpoint().getBlobServiceClient()).buildClient();
        return new BlobChangeFeedOperations(changefeedClient, this.configurationProxy);
    }

    private String determineContainerName(Exchange exchange) {
        String containerName = this.configurationProxy.getContainerName(exchange);
        if (ObjectHelper.isEmpty((String)containerName)) {
            throw new IllegalArgumentException("Container name must be specified");
        }
        return containerName;
    }

    public String determineBlobName(Exchange exchange) {
        String blobName = this.configurationProxy.getBlobName(exchange);
        if (ObjectHelper.isEmpty((String)blobName)) {
            throw new IllegalArgumentException("Blob name must be specified");
        }
        return blobName;
    }
}

