/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.component.azure.storage.blob.client.BlobContainerClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class BlobContainerOperations {
    private final BlobContainerClientWrapper client;
    private final BlobConfigurationOptionsProxy configurationProxy;

    public BlobContainerOperations(BlobConfiguration configuration, BlobContainerClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
        this.configurationProxy = new BlobConfigurationOptionsProxy(configuration);
    }

    public BlobOperationResponse listBlobs(Exchange exchange) {
        ListBlobsOptions listBlobOptions = this.configurationProxy.getListBlobOptions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        String regex = this.configurationProxy.getRegex(exchange);
        List<BlobItem> blobs = this.client.listBlobs(listBlobOptions, timeout);
        if (ObjectHelper.isEmpty((Object)regex)) {
            return BlobOperationResponse.create(blobs);
        }
        List filteredBlobs = blobs.stream().filter(x -> x.getName().matches(regex)).collect(Collectors.toCollection(LinkedList::new));
        return BlobOperationResponse.create(filteredBlobs);
    }

    public BlobOperationResponse createContainer(Exchange exchange) {
        Map<String, String> metadata = this.configurationProxy.getMetadata(exchange);
        PublicAccessType publicAccessType = this.configurationProxy.getPublicAccessType(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.createContainer(metadata, publicAccessType, timeout));
        return BlobOperationResponse.createWithEmptyBody(blobExchangeHeaders.toMap());
    }

    public BlobOperationResponse deleteContainer(Exchange exchange) {
        BlobRequestConditions blobRequestConditions = this.configurationProxy.getBlobRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        BlobExchangeHeaders blobExchangeHeaders = new BlobExchangeHeaders().httpHeaders(this.client.deleteContainer(blobRequestConditions, timeout));
        return BlobOperationResponse.createWithEmptyBody(blobExchangeHeaders.toMap());
    }
}

