/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.operations;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.camel.component.azure.servicebus.ServiceBusUtils;
import org.apache.camel.util.ObjectHelper;

public class ServiceBusSenderOperations {
    private final ServiceBusSenderClient client;

    public ServiceBusSenderOperations(ServiceBusSenderClient client) {
        ObjectHelper.notNull((Object)client, (String)"client");
        this.client = client;
    }

    public void sendMessages(Object data, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        if (data instanceof Iterable) {
            this.sendMessages((Iterable)data, context, applicationProperties, correlationId);
        } else {
            this.sendMessage(data, context, applicationProperties, correlationId);
        }
    }

    public List<Long> scheduleMessages(Object data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        if (ObjectHelper.isEmpty((Object)scheduledEnqueueTime)) {
            throw new IllegalArgumentException("To schedule a message, you need to set scheduledEnqueueTime.");
        }
        if (data instanceof Iterable) {
            return this.scheduleMessages((Iterable)data, scheduledEnqueueTime, context, applicationProperties, correlationId);
        }
        return this.scheduleMessage(data, scheduledEnqueueTime, context, applicationProperties, correlationId);
    }

    private void sendMessages(Iterable<?> data, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        Iterable<ServiceBusMessage> messages = ServiceBusUtils.createServiceBusMessages(data, applicationProperties, correlationId);
        if (ObjectHelper.isEmpty((Object)context)) {
            this.client.sendMessages(messages);
        } else {
            this.client.sendMessages(messages, context);
        }
    }

    private void sendMessage(Object data, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        ServiceBusMessage message = ServiceBusUtils.createServiceBusMessage(data, applicationProperties, correlationId);
        if (ObjectHelper.isEmpty((Object)context)) {
            this.client.sendMessage(message);
        } else {
            this.client.sendMessage(message, context);
        }
    }

    private List<Long> scheduleMessage(Object data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        ServiceBusMessage message = ServiceBusUtils.createServiceBusMessage(data, applicationProperties, correlationId);
        if (ObjectHelper.isEmpty((Object)context)) {
            return Collections.singletonList(this.client.scheduleMessage(message, scheduledEnqueueTime));
        }
        return Collections.singletonList(this.client.scheduleMessage(message, scheduledEnqueueTime, context));
    }

    private List<Long> scheduleMessages(Iterable<?> data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context, Map<String, Object> applicationProperties, String correlationId) {
        Iterable<ServiceBusMessage> messages = ServiceBusUtils.createServiceBusMessages(data, applicationProperties, correlationId);
        if (ObjectHelper.isEmpty((Object)context)) {
            return StreamSupport.stream(this.client.scheduleMessages(messages, scheduledEnqueueTime).spliterator(), false).toList();
        }
        return StreamSupport.stream(this.client.scheduleMessages(messages, scheduledEnqueueTime, context).spliterator(), false).toList();
    }
}

