/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-servicebus:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure Service bus receive messages response details")
public class ServicebusCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.servicebus.receiveMessages");
        if (message.getHeaders().containsKey("CamelAzureServiceBusPartitionKey")) {
            headers.put("CamelCloudEventSource", "azure.servicebus.partition." + (String)message.getHeader("CamelAzureServiceBusPartitionKey", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAzureServiceBusMessageId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        if (message.getHeaders().containsKey("CamelAzureServiceBusContentType")) {
            headers.put("Content-Type", message.getHeaders().containsKey("CamelAzureServiceBusContentType"));
        } else {
            headers.put("Content-Type", "application/octet-stream");
        }
    }
}

