/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusMessage;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ServiceBusUtils {
    private ServiceBusUtils() {
    }

    public static ServiceBusMessage createServiceBusMessage(Object data, Map<String, Object> applicationProperties) {
        ServiceBusMessage serviceBusMessage;
        if (data instanceof String) {
            serviceBusMessage = new ServiceBusMessage((String)data);
        } else if (data instanceof byte[]) {
            serviceBusMessage = new ServiceBusMessage((byte[])data);
        } else if (data instanceof BinaryData) {
            serviceBusMessage = new ServiceBusMessage((BinaryData)data);
        } else {
            throw new IllegalArgumentException("Make sure your message data is in String, byte[] or BinaryData");
        }
        if (applicationProperties != null) {
            serviceBusMessage.getRawAmqpMessage().getApplicationProperties().putAll(applicationProperties);
        }
        return serviceBusMessage;
    }

    public static Iterable<ServiceBusMessage> createServiceBusMessages(Iterable<Object> data, Map<String, Object> applicationProperties) {
        return StreamSupport.stream(data.spliterator(), false).map(obj -> ServiceBusUtils.createServiceBusMessage(obj, applicationProperties)).collect(Collectors.toList());
    }
}

