/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.key.vault.KeyVaultPropertiesFunction;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.vault.AzureVaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PeriodicTask(value="azure-secret-refresh")
public class EventhubsReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(EventhubsReloadTriggerTask.class);
    private static final String BLOB_SERVICE_URI_SEGMENT = ".blob.core.windows.net";
    private static final String SECRET_VERSION_ADD = "Microsoft.KeyVault.SecretNewVersionCreated";
    private CamelContext camelContext;
    private boolean reloadEnabled = true;
    private String secrets;
    private EventProcessorClient eventProcessorClient;
    private KeyVaultPropertiesFunction propertiesFunction;
    private volatile Instant lastCheckTime;
    private volatile Instant lastReloadTime;
    private final Map<String, Instant> updates = new HashMap<String, Instant>();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public Map<String, Instant> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public Instant getLastCheckTime() {
        return this.lastCheckTime;
    }

    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    protected void doStart() throws Exception {
        super.doStart();
        PropertiesComponent pc = this.camelContext.getPropertiesComponent();
        PropertiesFunction pf = pc.getPropertiesFunction("azure");
        if (pf instanceof KeyVaultPropertiesFunction) {
            this.propertiesFunction = (KeyVaultPropertiesFunction)pf;
            LOG.debug("Auto-detecting secrets from properties-function: {}", (Object)pf.getName());
        }
        this.secrets = this.camelContext.getVaultConfiguration().azure().getSecrets();
        if (ObjectHelper.isEmpty((String)this.secrets) && this.propertiesFunction == null) {
            throw new IllegalArgumentException("Secrets must be configured on Azure Key vault configuration");
        }
        String eventhubConnectionString = null;
        String blobAccessKey = null;
        String blobAccountName = null;
        String blobContainerName = null;
        AzureVaultConfiguration azureVaultConfiguration = this.getCamelContext().getVaultConfiguration().azure();
        if (ObjectHelper.isNotEmpty((Object)azureVaultConfiguration)) {
            eventhubConnectionString = azureVaultConfiguration.getEventhubConnectionString();
            blobAccessKey = azureVaultConfiguration.getBlobAccessKey();
            blobAccountName = azureVaultConfiguration.getBlobAccountName();
            blobContainerName = azureVaultConfiguration.getBlobContainerName();
        }
        if (!(ObjectHelper.isNotEmpty(eventhubConnectionString) && ObjectHelper.isNotEmpty(blobAccessKey) && ObjectHelper.isNotEmpty(blobAccountName) && ObjectHelper.isNotEmpty(blobContainerName))) {
            throw new RuntimeCamelException("Using the Azure Key Vault Secret refresh task requires setting Eventhub connection String, Blob Account Name, Blob Access Key and Blob Container Name  as application properties ");
        }
        BlobContainerAsyncClient c = new BlobContainerClientBuilder().endpoint(String.format(Locale.ROOT, "https://%s.blob.core.windows.net", blobAccountName)).containerName(blobContainerName).credential(new StorageSharedKeyCredential(blobAccountName, blobAccessKey)).buildAsyncClient();
        EventProcessorClientBuilder eventProcessorClientBuilder = new EventProcessorClientBuilder().checkpointStore((CheckpointStore)new BlobCheckpointStore(c)).consumerGroup("$Default").connectionString(eventhubConnectionString).processEvent(this::onEventListener).processError(this::onErrorListener).transportType(AmqpTransportType.AMQP);
        this.eventProcessorClient = eventProcessorClientBuilder.buildEventProcessorClient();
        this.eventProcessorClient.start();
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.eventProcessorClient != null) {
            try {
                this.eventProcessorClient.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.eventProcessorClient = null;
        }
        this.updates.clear();
    }

    @Override
    public void run() {
        this.lastCheckTime = Instant.now();
    }

    protected boolean matchSecret(String name) {
        HashSet<String> set = new HashSet<String>();
        if (this.secrets != null) {
            Collections.addAll(set, this.secrets.split(","));
        }
        if (this.propertiesFunction != null) {
            set.addAll(this.propertiesFunction.getSecrets());
        }
        for (String part : set) {
            boolean result = name.contains(part) || PatternHelper.matchPattern((String)name, (String)part);
            LOG.trace("Matching secret id: {}={} -> {}", new Object[]{name, part, result});
            if (!result) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Azure Secrets Refresh Task";
    }

    protected void onEventListener(EventContext eventContext) {
        ContextReloadStrategy reload;
        boolean triggerReloading = false;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualObj = EventhubsReloadTriggerTask.retrieveEventData(eventContext, mapper);
        for (int i = 0; i < actualObj.size(); ++i) {
            String secret = actualObj.get(i).get("subject").textValue();
            String eventType = actualObj.get(i).get("eventType").textValue();
            if (!ObjectHelper.isNotEmpty((String)secret) || !ObjectHelper.isNotEmpty((String)eventType) || !eventType.equalsIgnoreCase(SECRET_VERSION_ADD) || !this.matchSecret(secret)) continue;
            if (ObjectHelper.isNotEmpty((Object)eventContext.getEventData().getEnqueuedTime())) {
                this.updates.put(secret, eventContext.getEventData().getEnqueuedTime());
            }
            if (!this.isReloadEnabled()) continue;
            LOG.info("Update for Azure secret: {} detected, triggering CamelContext reload", (Object)secret);
            triggerReloading = true;
        }
        if (triggerReloading && (reload = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class)) != null) {
            this.lastReloadTime = Instant.now();
            reload.onReload((Object)this);
        }
    }

    private static JsonNode retrieveEventData(EventContext eventContext, ObjectMapper mapper) {
        try {
            return mapper.readTree(eventContext.getEventData().getBodyAsString());
        }
        catch (JsonProcessingException e) {
            LOG.warn("Unable to process event data body: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void onErrorListener(ErrorContext errorContext) {
    }
}

