/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Context;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.file.share.StorageFileInputStream;
import com.azure.storage.file.share.StorageFileOutputStream;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.ShareTokenIntent;
import com.azure.storage.file.share.options.ShareDirectoryCreateOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareListFilesAndDirectoriesOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.EmptyStackException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.azure.CredentialType;
import org.apache.camel.component.file.azure.FilesConfiguration;
import org.apache.camel.component.file.azure.FilesEndpoint;
import org.apache.camel.component.file.azure.FilesPath;
import org.apache.camel.component.file.azure.FilesToken;
import org.apache.camel.component.file.azure.FilesURIStrings;
import org.apache.camel.component.file.azure.NormalizedOperations;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesOperations
extends NormalizedOperations {
    public static final String HTTPS = "https";
    static final int HTTP_OK = 200;
    static final int HTTP_CREATED = 201;
    static final int HTTP_ACCEPTED = 202;
    static final int HTTP_NOT_FOUND = 404;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FilesEndpoint endpoint;
    private final FilesConfiguration configuration;
    private final FilesToken token;
    private ShareServiceClient client;
    private ShareDirectoryClient root;
    private ArrayDeque<ShareDirectoryClient> dirStack = new ArrayDeque();

    FilesOperations(FilesEndpoint endpoint) {
        super(endpoint.getConfiguration());
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.token = endpoint.getToken();
    }

    public void setEndpoint(GenericFileEndpoint<ShareFileItem> endpoint) {
        if (this.endpoint != endpoint) {
            throw new IllegalStateException("The endpoint is final: " + String.valueOf(endpoint));
        }
    }

    public GenericFile<ShareFileItem> newGenericFile() {
        this.log.trace("newGenericFile()");
        return new RemoteFile();
    }

    public boolean connect(RemoteFileConfiguration config, Exchange exchange) throws GenericFileOperationFailedException {
        this.log.trace("connect()");
        this.root = this.getClient().getShareClient(this.configuration.getShare()).getRootDirectoryClient();
        this.dirStack.push(this.root);
        return this.existsRemote(this.root);
    }

    public boolean isConnected() {
        this.log.trace("isConnected()");
        return this.root != null;
    }

    public void disconnect() {
        this.log.trace("disconnect()");
    }

    public void forceDisconnect() throws GenericFileOperationFailedException {
        this.log.debug("forceDisconnect()");
        int ms = this.configuration.getConnectTimeout();
        this.root.forceCloseAllHandles(true, Duration.ofMillis(ms), Context.NONE);
        this.root = null;
        this.dirStack = new ArrayDeque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        this.log.trace("deleteFile({})", (Object)name);
        this.reconnectIfNecessary(null);
        Object backup = this.backup();
        try {
            this.changeCurrentDirectory(FileUtil.onlyPath((String)name));
            boolean bl = this.deleteRemote(this.cwd(), FileUtil.stripPath((String)name));
            return bl;
        }
        finally {
            this.restore(backup);
        }
    }

    private boolean deleteRemote(ShareDirectoryClient dirClient, String fileName) {
        this.log.trace("{}> rm {}", (Object)dirClient.getDirectoryPath(), (Object)fileName);
        int status = dirClient.deleteFileIfExistsWithResponse(fileName, this.endpoint.getMetadataTimeout(), Context.NONE).getStatusCode();
        return status == 404 || status == 202;
    }

    void restore(Object backup) {
        this.dirStack = (ArrayDeque)backup;
    }

    Object backup() {
        return this.dirStack.clone();
    }

    private ShareDirectoryClient cwd() {
        ShareDirectoryClient cwd = this.dirStack.peek();
        return cwd;
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        this.log.trace("renameFile({}, {})", (Object)from, (Object)to);
        try {
            return this.renameRemote(this.getFileClient(from), FilesPath.ensureRelative(to));
        }
        catch (RuntimeException e) {
            throw new GenericFileOperationFailedException("Cannot rename: " + from + " to: " + to, (Throwable)e);
        }
    }

    private boolean renameRemote(ShareFileClient fileClient, String shareRelativeTo) {
        ShareFileRenameOptions options = new ShareFileRenameOptions(shareRelativeTo);
        options.setReplaceIfExists(Boolean.TRUE);
        ShareFileClient renamed = (ShareFileClient)fileClient.renameWithResponse(options, this.endpoint.getMetadataTimeout(), Context.NONE).getValue();
        return this.existsRemote(renamed);
    }

    @Override
    public boolean buildDirectory(String directory) throws GenericFileOperationFailedException {
        boolean success = this.existsDirectory(directory);
        if (!success) {
            success = this.buildDirectoryStepByStep(directory);
        }
        return success;
    }

    private boolean buildDirectoryStepByStep(String dir) {
        if (FilesPath.isRoot(dir)) {
            return true;
        }
        String[] steps = FilesPath.split(dir);
        ShareDirectoryClient stepClient = this.root;
        for (String step : steps) {
            if (this.existsRemote(stepClient = this.buildDirectoryRemote(stepClient, step))) continue;
            return false;
        }
        return true;
    }

    private ShareDirectoryClient buildDirectoryRemote(ShareDirectoryClient dirClient, String name) {
        this.log.trace("{}> mkdir {}", (Object)dirClient.getDirectoryPath(), (Object)name);
        ShareDirectoryCreateOptions options = new ShareDirectoryCreateOptions();
        return (ShareDirectoryClient)dirClient.createSubdirectoryIfNotExistsWithResponse(name, options, this.endpoint.getMetadataTimeout(), Context.NONE).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        boolean answer;
        this.log.trace("retrieveFile({})", (Object)name);
        Object backup = this.backup();
        try {
            answer = this.endpoint.getLocalWorkDirectory() != null ? this.retrieveFileToFileInLocalWorkDirectory(name, exchange, this.endpoint.isResumeDownload()) : this.retrieveFileToBody(name, exchange);
        }
        finally {
            this.restore(backup);
        }
        return answer;
    }

    public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        this.log.trace("releaseRetrievedFileResources({})", (Object)exchange.getExchangeId());
        InputStream is = (InputStream)exchange.getIn().getHeader("CamelRemoteFileInputStream", InputStream.class);
        if (is != null) {
            IOHelper.close((Closeable)is);
        }
    }

    private boolean retrieveFileToBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        boolean success = false;
        GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
        String path = FileUtil.onlyPath((String)name);
        if (path != null) {
            this.changeCurrentDirectory(path);
        }
        String remoteName = FileUtil.stripPath((String)name);
        if (this.configuration.isStreamDownload()) {
            this.log.trace("Prepared {} for download as opened input stream.", (Object)remoteName);
            StorageFileInputStream is = this.cwd().getFileClient(remoteName).openInputStream();
            target.setBody((Object)is);
            exchange.getIn().setHeader("CamelRemoteFileInputStream", (Object)is);
            success = true;
        } else {
            this.log.trace("Downloading {} to byte[] body.", (Object)remoteName);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ShareFileRange range = new ShareFileRange(0L);
            ShareFileDownloadResponse ret = this.cwd().getFileClient(remoteName).downloadWithResponse((OutputStream)os, range, null, this.endpoint.getDataTimeout(), Context.NONE);
            success = ret.getStatusCode() == 200;
            IOHelper.close((Closeable)os);
            target.setBody((Object)os.toByteArray());
        }
        return success;
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange, boolean resumeDownload) throws GenericFileOperationFailedException {
        boolean result;
        FileOutputStream os;
        File inProgress;
        File local = new File(FileUtil.normalizePath((String)this.endpoint.getLocalWorkDirectory()));
        long existingSize = -1L;
        try {
            GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
            String relativeName = target.getRelativeFilePath();
            inProgress = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            boolean result2 = local.mkdirs();
            if (!result2) {
                this.log.warn("Failed to create local directory {} while retrieving file in local work directory. Directory may already exist or have been created externally", (Object)local);
            }
            if (local.exists() && !FileUtil.deleteFile((File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + String.valueOf(local));
            }
            boolean exists = inProgress.exists();
            if (exists) {
                existingSize = inProgress.length();
            }
            if (!resumeDownload) {
                if (exists && !FileUtil.deleteFile((File)inProgress)) {
                    throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + String.valueOf(inProgress));
                }
                if (!inProgress.createNewFile()) {
                    throw new GenericFileOperationFailedException("Cannot create new local work file: " + String.valueOf(inProgress));
                }
            }
            boolean append = resumeDownload && existingSize > 0L;
            os = new FileOutputStream(inProgress, append);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + String.valueOf(local), (Throwable)e);
        }
        try {
            GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            target.setBody((Object)local);
            String path = FileUtil.onlyPath((String)name);
            if (path != null) {
                this.changeCurrentDirectory(path);
            }
            String remoteName = FileUtil.stripPath((String)name);
            ShareFileRange range = new ShareFileRange(0L);
            if (resumeDownload && existingSize > 0L) {
                this.log.trace("Client restartOffset: {}", (Object)existingSize);
                this.log.debug("Resuming download of file: {} at position: {}", (Object)remoteName, (Object)existingSize);
                range = new ShareFileRange(existingSize);
            }
            this.log.trace("Downloading {} to local work directory.", (Object)remoteName);
            ShareFileDownloadResponse ret = this.cwd().getFileClient(remoteName).downloadWithResponse((OutputStream)os, range, null, this.endpoint.getDataTimeout(), Context.NONE);
            result = ret.getStatusCode() == 200;
        }
        catch (RuntimeException e) {
            this.log.trace("Error occurred during retrieving file: {} to local directory.", (Object)name);
            if (!resumeDownload) {
                this.log.trace("Deleting local work file: {}", (Object)name);
                IOHelper.close((Closeable)os, (String)("retrieve: " + name), (Logger)this.log);
                boolean deleted = FileUtil.deleteFile((File)inProgress);
                if (!deleted) {
                    this.log.warn("Error occurred during retrieving file: {} to local directory. Cannot delete local work file: {}", (Object)inProgress, (Object)name);
                }
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (Logger)this.log);
        }
        this.log.debug("Retrieve file to local work file result: {}", (Object)result);
        if (result) {
            this.log.trace("Renaming local in progress file from: {} to: {}", (Object)inProgress, (Object)local);
            try {
                if (!FileUtil.renameFile((File)inProgress, (File)local, (boolean)false)) {
                    throw new GenericFileOperationFailedException("Cannot rename local work file from: " + String.valueOf(inProgress) + " to: " + String.valueOf(local));
                }
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + String.valueOf(inProgress) + " to: " + String.valueOf(local), (Throwable)e);
            }
        }
        return result;
    }

    public boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
        boolean answer;
        this.log.trace("storeFile({},,{})", (Object)name, (Object)size);
        name = this.configuration.normalizePath(name);
        String path = FileUtil.onlyPath((String)name);
        String targetName = name;
        Object backup = this.backup();
        try {
            if (path != null) {
                this.changeCurrentDirectory(path);
                targetName = FileUtil.stripPath((String)name);
            }
            answer = this.storeFile(name, targetName, exchange);
        }
        catch (GenericFileOperationFailedException e) {
            throw e;
        }
        finally {
            this.restore(backup);
        }
        return answer;
    }

    private boolean storeFile(String name, String targetName, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        boolean existFile = false;
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail) {
            existFile = this.existsFile(targetName);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                this.log.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
        }
        InputStream is = null;
        int length = 0;
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                this.log.trace("Writing empty file.");
                is = new ByteArrayInputStream(new byte[0]);
            } else {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
        }
        try {
            if (is == null) {
                Long knownLength = (Long)exchange.getIn().getHeader("CamelFileLength", Long.class);
                if (knownLength != null) {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                    length = knownLength.intValue();
                } else {
                    this.log.warn("No file length header, so converting body to byte[].  It might be memory intensive.");
                    byte[] bytes = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
                    length = bytes.length;
                    is = new ByteArrayInputStream(bytes);
                }
            }
            StopWatch watch = new StopWatch();
            boolean answer = false;
            this.log.debug("About to store file: {} length: {} using stream: {}", new Object[]{targetName, length, is});
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Append) {
                assert (false);
            } else {
                ShareDirectoryClient cwd = this.cwd();
                ShareFileClient file = cwd.getFileClient(targetName);
                if (this.deleteRemote(cwd, targetName) && this.createRemote(file, length)) {
                    this.storeRemote(file, is);
                    answer = true;
                }
            }
            if (this.log.isDebugEnabled()) {
                long time = watch.taken();
                this.log.debug("Took {} ({} millis) to store: {} and files client returned: {}", new Object[]{TimeUtils.printDuration((long)time, (boolean)true), time, targetName, answer});
            }
            bl = answer;
        }
        catch (IOException | InvalidPayloadException e) {
            try {
                throw new GenericFileOperationFailedException("Cannot store file: " + name, e);
            }
            catch (Throwable throwable) {
                IOHelper.close(is, (String)("store: " + name), (Logger)this.log);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is, (String)("store: " + name), (Logger)this.log);
        return bl;
    }

    private void storeRemote(ShareFileClient file, InputStream is) throws IOException {
        this.log.trace("> put {}", (Object)file.getFilePath());
        try (StorageFileOutputStream os = file.getFileOutputStream();){
            is.transferTo((OutputStream)os);
            os.flush();
        }
    }

    private boolean createRemote(ShareFileClient fileClient, int length) {
        int code = fileClient.createWithResponse((long)length, null, null, null, null, this.endpoint.getMetadataTimeout(), Context.NONE).getStatusCode();
        return code == 201 || code == 200;
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        this.log.trace("existsFile({})", (Object)name);
        return this.existsRemote(this.getFileClient(name));
    }

    private boolean existsDirectory(String path) {
        return this.existsRemote(this.getDirClient(path));
    }

    private boolean existsRemote(ShareDirectoryClient dirClient) {
        try {
            return Boolean.TRUE.equals(dirClient.existsWithResponse(this.endpoint.getMetadataTimeout(), Context.NONE).getValue());
        }
        catch (ShareStorageException ex) {
            if (ex.getStatusCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    private boolean existsRemote(ShareFileClient fileClient) {
        try {
            return Boolean.TRUE.equals(fileClient.existsWithResponse(this.endpoint.getMetadataTimeout(), Context.NONE).getValue());
        }
        catch (ShareStorageException ex) {
            if (ex.getStatusCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        String answer = this.cwd().getDirectoryPath();
        this.log.trace("getCurrentDirectory(): {}", (Object)answer);
        return answer;
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        String[] dirs;
        this.log.trace("changeCurrentDirectory({})", (Object)path);
        if (FilesPath.isEmpty(path) || path.equals(".") || path.equals("/" + this.cwd().getDirectoryPath())) {
            return;
        }
        for (String dir : dirs = FilesPath.splitToSteps(path, true)) {
            this.trivialCd(dir);
        }
    }

    private void trivialCd(String pathStep) {
        boolean success;
        if (FilesPath.isEmptyStep(pathStep)) {
            return;
        }
        ShareDirectoryClient cwd = this.cwd();
        this.log.trace("{}> cd {}", (Object)cwd.getDirectoryPath(), (Object)pathStep);
        try {
            if ("/".equals(pathStep)) {
                this.changeToRoot();
                success = true;
            } else if ("..".equals(pathStep)) {
                this.changeToParentDirectory();
                success = true;
            } else {
                ShareDirectoryClient subDir = cwd.getSubdirectoryClient(pathStep);
                success = this.existsRemote(subDir);
                if (success) {
                    this.dirStack.push(subDir);
                }
            }
        }
        catch (RuntimeException e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
        if (!success) {
            throw new GenericFileOperationFailedException("Cannot cd(" + pathStep + ").");
        }
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        this.log.trace("changeToParentDirectory()");
        try {
            this.dirStack.pop();
        }
        catch (EmptyStackException e) {
            throw new GenericFileOperationFailedException("Root dir does not have parent.", (Throwable)e);
        }
    }

    void changeToRoot() {
        if (!this.isConnected()) {
            throw new GenericFileOperationFailedException("Cannot cd to the share root: not connected");
        }
        this.dirStack.push(this.root);
    }

    public ShareFileItem[] listFiles() throws GenericFileOperationFailedException {
        this.log.trace("listFiles()");
        return this.listRemote(this.cwd());
    }

    public ShareFileItem[] listFiles(String path) throws GenericFileOperationFailedException {
        this.log.trace("listFiles({})", (Object)path);
        return this.listRemote(this.getDirClient(path));
    }

    private ShareDirectoryClient getDirClient(String path) {
        assert (FilesPath.isAbsolute(path));
        if (FilesPath.isRoot(path)) {
            return this.root;
        }
        String dir = FilesPath.ensureRelative(path);
        return this.root.getSubdirectoryClient(dir);
    }

    private ShareFileClient getFileClient(String path) {
        assert (FilesPath.isAbsolute(path)) : "Expecting /a_path from share root, got: " + path;
        assert (!FilesPath.isRoot(path)) : "Expecting /a_path from share root, got: " + path;
        return this.root.getFileClient(FilesPath.ensureRelative(path));
    }

    private ShareFileItem[] listRemote(ShareDirectoryClient dir) {
        this.log.trace("{}> ls -a", (Object)dir.getDirectoryPath());
        try {
            ShareListFilesAndDirectoriesOptions withTS = new ShareListFilesAndDirectoriesOptions().setIncludeTimestamps(true);
            return (ShareFileItem[])dir.listFilesAndDirectories(withTS, this.endpoint.getMetadataTimeout(), Context.NONE).stream().toArray(ShareFileItem[]::new);
        }
        catch (RuntimeException e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean sendNoop() throws GenericFileOperationFailedException {
        this.log.trace("sendNoOp()");
        return this.existsRemote(this.root);
    }

    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        this.log.trace("sendSiteCommand({})", (Object)command);
        return true;
    }

    public ShareServiceClient getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    private ShareServiceClient createClient() {
        ShareServiceClientBuilder builder = new ShareServiceClientBuilder().endpoint("https://" + this.configuration.getHost());
        String sharedKey = this.configuration.getSharedKey();
        if (this.configuration.getCredentialType().equals((Object)CredentialType.SHARED_ACCOUNT_KEY) && sharedKey != null) {
            String keyB64 = FilesURIStrings.reconstructBase64EncodedValue(sharedKey);
            builder.credential(new StorageSharedKeyCredential(this.configuration.getAccount(), keyB64));
        } else if (this.configuration.getCredentialType().equals((Object)CredentialType.AZURE_SAS)) {
            builder = builder.sasToken(this.token.toURIQuery());
        } else if (this.configuration.getCredentialType().equals((Object)CredentialType.AZURE_IDENTITY)) {
            builder = builder.credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
            builder.shareTokenIntent(ShareTokenIntent.BACKUP);
        }
        return builder.buildClient();
    }

    void reconnectIfNecessary(Exchange exchange) throws GenericFileOperationFailedException {
        boolean reconnectRequired;
        try {
            reconnectRequired = !this.isConnected();
        }
        catch (GenericFileOperationFailedException e) {
            this.log.trace("Going to reconnect because of: ", (Throwable)e);
            reconnectRequired = true;
        }
        if (reconnectRequired) {
            this.log.trace("Probing if the file service is connectible ...");
            this.connect(this.configuration, exchange);
        }
    }
}

