/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.camel.util.URISupport;

final class FilesURIStrings {
    public static final char QUERY_SEPARATOR = '?';

    private FilesURIStrings() {
    }

    static URI getBaseURI(String uri) throws URISyntaxException {
        String baseUri = uri;
        if (uri.indexOf(63) != -1) {
            baseUri = uri.substring(0, uri.indexOf(63));
        }
        return new URI(baseUri);
    }

    static String reconstructBase64EncodedValue(String value) {
        return value.replace(" ", "+");
    }

    static String encodeTokenValue(String value) throws URISyntaxException {
        return URISupport.createQueryString(Collections.singletonMap("x", value)).substring(2).replace("+", "%2B").replace("%3A", ":");
    }
}

