/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.util.ObjectHelper;

public class EventHubsConfigurationOptionsProxy {
    private final EventHubsConfiguration configuration;

    public EventHubsConfigurationOptionsProxy(EventHubsConfiguration configuration) {
        this.configuration = configuration;
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)exchange.getIn().getHeader(headerName, classType);
    }

    public String getPartitionKey(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureEventHubsPartitionKey", this.configuration::getPartitionKey, String.class);
    }

    public String getPartitionId(Exchange exchange) {
        return this.getOption(exchange, "CamelAzureEventHubsPartitionId", this.configuration::getPartitionId, String.class);
    }

    public EventHubsConfiguration getConfiguration() {
        return this.configuration;
    }

    private <R> R getOption(Exchange exchange, String headerName, Supplier<R> fallbackFn, Class<R> type) {
        return ObjectHelper.isEmpty((Object)exchange) || ObjectHelper.isEmpty(EventHubsConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type)) ? fallbackFn.get() : EventHubsConfigurationOptionsProxy.getObjectFromHeaders(exchange, headerName, type);
    }
}

