/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.client;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.util.CosmosPagedFlux;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Mono;

public class CosmosAsyncClientWrapper {
    private final CosmosAsyncClient client;

    public CosmosAsyncClientWrapper(CosmosAsyncClient client) {
        ObjectHelper.isNotEmpty((Object)client);
        this.client = client;
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) {
        return this.client.createDatabaseIfNotExists(databaseProperties);
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id) {
        return this.client.createDatabaseIfNotExists(id);
    }

    public Mono<CosmosDatabaseResponse> createDatabaseIfNotExists(String id, ThroughputProperties throughputProperties) {
        return this.client.createDatabaseIfNotExists(id, throughputProperties);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) {
        return this.client.createDatabase(databaseProperties, options);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties) {
        return this.client.createDatabase(databaseProperties);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id) {
        return this.client.createDatabase(id);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties, CosmosDatabaseRequestOptions options) {
        return this.client.createDatabase(databaseProperties, throughputProperties, options);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseProperties, ThroughputProperties throughputProperties) {
        return this.client.createDatabase(databaseProperties, throughputProperties);
    }

    public Mono<CosmosDatabaseResponse> createDatabase(String id, ThroughputProperties throughputProperties) {
        return this.client.createDatabase(id, throughputProperties);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases() {
        return this.client.readAllDatabases();
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(String query, CosmosQueryRequestOptions options) {
        return this.client.queryDatabases(query, options);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.client.queryDatabases(querySpec, options);
    }

    public CosmosAsyncDatabase getDatabase(String id) {
        return this.client.getDatabase(id);
    }

    public void close() {
        this.client.close();
    }
}

