/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.component.azure.cosmosdb.CosmosDbEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="azure-cosmosdb")
public class CosmosDbComponent
extends DefaultComponent {
    @Metadata
    private CosmosDbConfiguration configuration = new CosmosDbConfiguration();

    public CosmosDbComponent() {
    }

    public CosmosDbComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CosmosDbConfiguration configuration;
        CosmosDbConfiguration cosmosDbConfiguration = configuration = this.configuration != null ? this.configuration.copy() : new CosmosDbConfiguration();
        if (ObjectHelper.isNotEmpty((String)remaining) && remaining.trim().length() > 0) {
            String[] parts = remaining.split("/");
            configuration.setDatabaseName(parts[0]);
            if (parts.length > 1) {
                configuration.setContainerName(parts[1]);
            }
        }
        CosmosDbEndpoint endpoint = new CosmosDbEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.validateConfigurations(configuration);
        return endpoint;
    }

    public CosmosDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CosmosDbConfiguration configuration) {
        this.configuration = configuration;
    }

    private void validateConfigurations(CosmosDbConfiguration configuration) {
        if (configuration.getCosmosAsyncClient() == null && ObjectHelper.isEmpty((String)configuration.getDatabaseEndpoint())) {
            throw new IllegalArgumentException("Azure CosmosDB database endpoint must be specified.");
        }
    }
}

