/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.operations;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import java.util.function.Function;
import org.apache.camel.component.azure.cosmosdb.CosmosDbUtils;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbContainerOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosDbDatabaseOperations {
    private final Mono<CosmosAsyncDatabase> database;

    public CosmosDbDatabaseOperations(Mono<CosmosAsyncDatabase> database) {
        this.database = database;
    }

    public Mono<String> getDatabaseId() {
        return this.database.map(CosmosAsyncDatabase::getId);
    }

    public Mono<CosmosDatabaseResponse> deleteDatabase(CosmosDatabaseRequestOptions databaseRequestOptions) {
        return this.applyToDatabase(database -> database.delete(databaseRequestOptions));
    }

    public Mono<CosmosContainerResponse> createContainer(String containerId, String containerPartitionKeyPath, ThroughputProperties throughputProperties) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(containerId, "containerId");
        CosmosDbUtils.validateIfParameterIsNotEmpty(containerPartitionKeyPath, "containerPartitionKeyPath");
        String enhancedContainerPartitionKeyPath = !containerPartitionKeyPath.startsWith("/") ? "/" + containerPartitionKeyPath : containerPartitionKeyPath;
        return this.applyToDatabase(database -> database.createContainerIfNotExists(containerId, enhancedContainerPartitionKeyPath, throughputProperties));
    }

    public CosmosDbContainerOperations createContainerIfNotExistAndGetContainerOperations(String containerId, String containerPartitionKeyPath, ThroughputProperties throughputProperties) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(containerId, "containerId");
        CosmosDbUtils.validateIfParameterIsNotEmpty(containerPartitionKeyPath, "containerPartitionKeyPath");
        return new CosmosDbContainerOperations(this.getAndCreateContainerIfNotExist(containerId, containerPartitionKeyPath, true, throughputProperties));
    }

    public CosmosDbContainerOperations getContainerOperations(String containerId) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(containerId, "containerId");
        return new CosmosDbContainerOperations(this.getAndCreateContainerIfNotExist(containerId, null, false, null));
    }

    public Mono<ThroughputResponse> replaceDatabaseThroughput(ThroughputProperties throughputProperties) {
        return this.applyToDatabase(database -> database.replaceThroughput(throughputProperties));
    }

    public Flux<CosmosContainerProperties> readAllContainers(CosmosQueryRequestOptions queryRequestOptions) {
        return this.database.flatMapMany(database -> CosmosDbUtils.convertCosmosPagedFluxToFluxResults(database.readAllContainers(queryRequestOptions)));
    }

    public Flux<CosmosContainerProperties> queryContainers(String query, CosmosQueryRequestOptions queryRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(query, "query");
        return this.database.flatMapMany(database -> CosmosDbUtils.convertCosmosPagedFluxToFluxResults(database.queryContainers(query, queryRequestOptions)));
    }

    private Mono<CosmosAsyncContainer> getAndCreateContainerIfNotExist(String containerId, String containerPartitionKeyPath, boolean createContainerIfNotExist, ThroughputProperties throughputProperties) {
        if (createContainerIfNotExist) {
            return this.createContainer(containerId, containerPartitionKeyPath, throughputProperties).then(this.database).map(database -> this.getContainer((CosmosAsyncDatabase)database, containerId));
        }
        return this.database.map(database -> this.getContainer((CosmosAsyncDatabase)database, containerId));
    }

    private CosmosAsyncContainer getContainer(CosmosAsyncDatabase database, String containerId) {
        return database.getContainer(containerId);
    }

    private <T> Mono<T> applyToDatabase(Function<CosmosAsyncDatabase, Mono<T>> fn) {
        return this.database.flatMap(fn);
    }
}

