/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.operations;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ChangeFeedProcessorBuilder;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.component.azure.cosmosdb.CosmosDbUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosDbContainerOperations {
    private final Mono<CosmosAsyncContainer> container;

    public CosmosDbContainerOperations(Mono<CosmosAsyncContainer> container) {
        this.container = container;
    }

    public Mono<CosmosAsyncContainer> getContainer() {
        return this.container;
    }

    public Mono<String> getContainerId() {
        return this.container.map(CosmosAsyncContainer::getId);
    }

    public Mono<CosmosContainerResponse> deleteContainer(CosmosContainerRequestOptions containerRequestOptions) {
        return this.applyToContainer(container -> container.delete(containerRequestOptions));
    }

    public Mono<ThroughputResponse> replaceContainerThroughput(ThroughputProperties throughputProperties) {
        return this.applyToContainer(container -> container.replaceThroughput(throughputProperties));
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(item, "item");
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        return this.applyToContainer(container -> container.createItem(item, partitionKey, itemRequestOptions));
    }

    public <T> Flux<CosmosItemResponse<T>> createItems(List<T> items, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(items, "items");
        return Flux.fromIterable(items).flatMap(item -> this.createItem(item, partitionKey, itemRequestOptions));
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(item, "item");
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        return this.applyToContainer(container -> container.upsertItem(item, partitionKey, itemRequestOptions));
    }

    public <T> Flux<CosmosItemResponse<T>> upsertItems(List<T> items, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(items, "items");
        return Flux.fromIterable(items).flatMap(item -> this.upsertItem(item, partitionKey, itemRequestOptions));
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemId, "itemId");
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        return this.applyToContainer(container -> container.deleteItem(itemId, partitionKey, itemRequestOptions));
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(item, "item");
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemId, "itemId");
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        return this.applyToContainer(container -> container.replaceItem(item, itemId, partitionKey, itemRequestOptions));
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions itemRequestOptions, Class<T> itemType) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemId, "itemId");
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemType, "itemType");
        return this.applyToContainer(container -> container.readItem(itemId, partitionKey, itemRequestOptions, itemType));
    }

    public <T> Flux<T> readAllItems(PartitionKey partitionKey, CosmosQueryRequestOptions queryRequestOptions, Class<T> itemType) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(partitionKey, "partitionKey");
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemType, "itemType");
        CosmosQueryRequestOptions requestOptions = queryRequestOptions == null ? new CosmosQueryRequestOptions() : queryRequestOptions;
        return this.container.flatMapMany(container -> CosmosDbUtils.convertCosmosPagedFluxToFluxResults(container.readAllItems(partitionKey, requestOptions, itemType)));
    }

    public <T> Flux<T> queryItems(String query, CosmosQueryRequestOptions queryRequestOptions, Class<T> itemType) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(query, "query");
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemType, "itemType");
        return this.container.flatMapMany(container -> CosmosDbUtils.convertCosmosPagedFluxToFluxResults(container.queryItems(query, queryRequestOptions, itemType)));
    }

    public <T> Flux<FeedResponse<T>> queryItemsAsFeed(String query, CosmosQueryRequestOptions queryRequestOptions, Class<T> itemType) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(query, "query");
        CosmosDbUtils.validateIfParameterIsNotEmpty(itemType, "itemType");
        return this.container.flatMapMany(container -> container.queryItems(query, queryRequestOptions, itemType).byPage());
    }

    public ChangeFeedProcessor captureEventsWithChangeFeed(Mono<CosmosAsyncContainer> leaseContainerMono, String hostName, Consumer<List<Map<String, ?>>> resultsCallback, ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        CosmosDbUtils.validateIfParameterIsNotEmpty(leaseContainerMono, "leaseContainer");
        CosmosDbUtils.validateIfParameterIsNotEmpty(resultsCallback, "resultsCallback");
        CosmosDbUtils.validateIfParameterIsNotEmpty(hostName, "hostName");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        return (ChangeFeedProcessor)this.container.zipWith(leaseContainerMono).map(tupleResults -> {
            CosmosAsyncContainer feedContainer = (CosmosAsyncContainer)tupleResults.getT1();
            CosmosAsyncContainer leaseContainer = (CosmosAsyncContainer)tupleResults.getT2();
            return new ChangeFeedProcessorBuilder().feedContainer(feedContainer).leaseContainer(leaseContainer).handleChanges(jsonNodes -> {
                List events = jsonNodes.stream().map(jsonNode -> (Map)mapper.convertValue(jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){})).collect(Collectors.toList());
                resultsCallback.accept(events);
            }).hostName(hostName).options(changeFeedProcessorOptions).buildChangeFeedProcessor();
        }).block();
    }

    private <T> Mono<T> applyToContainer(Function<CosmosAsyncContainer, Mono<T>> fn) {
        return this.container.flatMap(fn);
    }
}

