/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.query;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.timestream.Timestream2AbstractEndpoint;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.client.Timestream2ClientFactory;
import org.apache.camel.component.aws2.timestream.query.Timestream2QueryProducer;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;

public class Timestream2QueryEndpoint
extends Timestream2AbstractEndpoint {
    private TimestreamQueryClient awsTimestreamQueryClient;

    public Timestream2QueryEndpoint(String uri, Component component, Timestream2Configuration configuration) {
        super(uri, component, configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Timestream2QueryProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsTimestreamQueryClient = this.getConfiguration().getAwsTimestreamQueryClient() != null ? this.getConfiguration().getAwsTimestreamQueryClient() : Timestream2ClientFactory.getTimestreamClient(this.getConfiguration()).getTimestreamQueryClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getConfiguration().getAwsTimestreamQueryClient()) && this.awsTimestreamQueryClient != null) {
            this.awsTimestreamQueryClient.close();
        }
        super.doStop();
    }

    public TimestreamQueryClient getAwsTimestreamQueryClient() {
        return this.awsTimestreamQueryClient;
    }
}

