/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.timestream.write;

import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.Timestream2Operations;
import org.apache.camel.component.aws2.timestream.write.Timestream2WriteEndpoint;
import org.apache.camel.component.aws2.timestream.write.Timestream2WriteProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.MagneticStoreWriteProperties;
import software.amazon.awssdk.services.timestreamwrite.model.Record;
import software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ResumeBatchLoadTaskResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RetentionProperties;
import software.amazon.awssdk.services.timestreamwrite.model.Schema;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;

public class Timestream2WriteProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Timestream2WriteProducer.class);
    private transient String timestreamWriteProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public Timestream2WriteProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case describeEndpoints: {
                this.describeEndpoints(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case createBatchLoadTask: {
                this.createBatchLoadTask(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case describeBatchLoadTask: {
                this.describeBatchLoadTask(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case resumeBatchLoadTask: {
                this.resumeBatchLoadTask(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case listBatchLoadTasks: {
                this.listBatchLoadTasks(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case createDatabase: {
                this.createDatabase(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case deleteDatabase: {
                this.deleteDatabase(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case describeDatabase: {
                this.describeDatabase(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case updateDatabase: {
                this.updateDatabase(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case listDatabases: {
                this.listDatabases(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case createTable: {
                this.createTable(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case deleteTable: {
                this.deleteTable(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case describeTable: {
                this.describeTable(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case updateTable: {
                this.updateTable(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case listTables: {
                this.listTables(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            case writeRecords: {
                this.writeRecords(this.getEndpoint().getAwsTimestreamWriteClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private Timestream2Operations determineOperation(Exchange exchange) throws InvalidPayloadException {
        Timestream2Operations operation = (Timestream2Operations)((Object)exchange.getIn().getHeader("CamelAwsTimestreamOperation", Timestream2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Timestream2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.timestreamWriteProducerToString == null) {
            this.timestreamWriteProducerToString = "TimestreamWriteProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.timestreamWriteProducerToString;
    }

    public Timestream2WriteEndpoint getEndpoint() {
        return (Timestream2WriteEndpoint)super.getEndpoint();
    }

    private void describeEndpoints(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeEndpointsRequest) {
                DescribeEndpointsResponse result;
                DescribeEndpointsRequest request = (DescribeEndpointsRequest)payload;
                try {
                    result = timestreamWriteClient.describeEndpoints(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Endpoints command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeEndpointsResponse result;
            DescribeEndpointsRequest.Builder builder = DescribeEndpointsRequest.builder();
            try {
                result = timestreamWriteClient.describeEndpoints((DescribeEndpointsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Endpoints command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createBatchLoadTask(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateBatchLoadTaskRequest) {
                CreateBatchLoadTaskResponse result;
                CreateBatchLoadTaskRequest request = (CreateBatchLoadTaskRequest)payload;
                try {
                    result = timestreamWriteClient.createBatchLoadTask(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateBatchLoadTaskResponse result;
            DataModelConfiguration config;
            CreateBatchLoadTaskRequest.Builder builder = CreateBatchLoadTaskRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsTimestreamClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTargetDatabaseName"))) {
                String targetDB = (String)exchange.getIn().getHeader("CamelAwsTimestreamTargetDatabaseName", String.class);
                builder.targetDatabaseName(targetDB);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTargetTableName"))) {
                String targetTable = (String)exchange.getIn().getHeader("CamelAwsTimestreamTargetTableName", String.class);
                builder.targetTableName(targetTable);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamRecordVersion"))) {
                Long recordVersion = (Long)exchange.getIn().getHeader("CamelAwsTimestreamRecordVersion", Long.class);
                builder.recordVersion(recordVersion);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDataModelConfiguration"))) {
                config = (DataModelConfiguration)exchange.getIn().getHeader("CamelAwsTimestreamDataModelConfiguration", DataModelConfiguration.class);
                builder.dataModelConfiguration(config);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDataSourceConfiguration"))) {
                config = (DataSourceConfiguration)exchange.getIn().getHeader("CamelAwsTimestreamDataSourceConfiguration", DataSourceConfiguration.class);
                builder.dataSourceConfiguration((DataSourceConfiguration)config);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamReportConfiguration"))) {
                config = (ReportConfiguration)exchange.getIn().getHeader("CamelAwsTimestreamReportConfiguration", ReportConfiguration.class);
                builder.reportConfiguration((ReportConfiguration)config);
            }
            try {
                result = timestreamWriteClient.createBatchLoadTask((CreateBatchLoadTaskRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeBatchLoadTask(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeBatchLoadTaskRequest) {
                DescribeBatchLoadTaskResponse result;
                DescribeBatchLoadTaskRequest request = (DescribeBatchLoadTaskRequest)payload;
                try {
                    result = timestreamWriteClient.describeBatchLoadTask(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeBatchLoadTaskResponse result;
            DescribeBatchLoadTaskRequest.Builder builder = DescribeBatchLoadTaskRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTaskId"))) {
                String taskId = (String)exchange.getIn().getHeader("CamelAwsTimestreamTaskId", String.class);
                builder.taskId(taskId);
            }
            try {
                result = timestreamWriteClient.describeBatchLoadTask((DescribeBatchLoadTaskRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void resumeBatchLoadTask(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ResumeBatchLoadTaskRequest) {
                ResumeBatchLoadTaskResponse result;
                ResumeBatchLoadTaskRequest request = (ResumeBatchLoadTaskRequest)payload;
                try {
                    result = timestreamWriteClient.resumeBatchLoadTask(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Resume Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ResumeBatchLoadTaskResponse result;
            ResumeBatchLoadTaskRequest.Builder builder = ResumeBatchLoadTaskRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTaskId"))) {
                String taskId = (String)exchange.getIn().getHeader("CamelAwsTimestreamTaskId", String.class);
                builder.taskId(taskId);
            }
            try {
                result = timestreamWriteClient.resumeBatchLoadTask((ResumeBatchLoadTaskRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Resume Batch Load Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listBatchLoadTasks(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListBatchLoadTasksRequest) {
                ListBatchLoadTasksResponse result;
                ListBatchLoadTasksRequest request = (ListBatchLoadTasksRequest)payload;
                try {
                    result = timestreamWriteClient.listBatchLoadTasks(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Batch Load Tasks command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListBatchLoadTasksResponse result;
            ListBatchLoadTasksRequest.Builder builder = ListBatchLoadTasksRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTaskStatus"))) {
                String taskStatus = (String)exchange.getIn().getHeader("CamelAwsTimestreamTaskStatus", String.class);
                builder.taskStatus(taskStatus);
            }
            try {
                result = timestreamWriteClient.listBatchLoadTasks((ListBatchLoadTasksRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Batch Load Tasks command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createDatabase(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateDatabaseRequest) {
                CreateDatabaseResponse result;
                CreateDatabaseRequest request = (CreateDatabaseRequest)payload;
                try {
                    result = timestreamWriteClient.createDatabase(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateDatabaseResponse result;
            CreateDatabaseRequest.Builder builder = CreateDatabaseRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId"))) {
                String kmsKeyId = (String)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId", String.class);
                builder.kmsKeyId(kmsKeyId);
            }
            try {
                result = timestreamWriteClient.createDatabase((CreateDatabaseRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteDatabase(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteDatabaseRequest) {
                DeleteDatabaseResponse result;
                DeleteDatabaseRequest request = (DeleteDatabaseRequest)payload;
                try {
                    result = timestreamWriteClient.deleteDatabase(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteDatabaseResponse result;
            DeleteDatabaseRequest.Builder builder = DeleteDatabaseRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            try {
                result = timestreamWriteClient.deleteDatabase((DeleteDatabaseRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeDatabase(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeDatabaseRequest) {
                DescribeDatabaseResponse result;
                DescribeDatabaseRequest request = (DescribeDatabaseRequest)payload;
                try {
                    result = timestreamWriteClient.describeDatabase(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeDatabaseResponse result;
            DescribeDatabaseRequest.Builder builder = DescribeDatabaseRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            try {
                result = timestreamWriteClient.describeDatabase((DescribeDatabaseRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateDatabase(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateDatabaseRequest) {
                UpdateDatabaseResponse result;
                UpdateDatabaseRequest request = (UpdateDatabaseRequest)payload;
                try {
                    result = timestreamWriteClient.updateDatabase(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateDatabaseResponse result;
            UpdateDatabaseRequest.Builder builder = UpdateDatabaseRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId"))) {
                String kmsKeyId = (String)exchange.getIn().getHeader("CamelAwsTimestreamKmsKeyId", String.class);
                builder.kmsKeyId(kmsKeyId);
            }
            try {
                result = timestreamWriteClient.updateDatabase((UpdateDatabaseRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update Database command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listDatabases(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListDatabasesRequest) {
                ListDatabasesResponse result;
                ListDatabasesRequest request = (ListDatabasesRequest)payload;
                try {
                    result = timestreamWriteClient.listDatabases(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Databases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListDatabasesResponse result;
            ListDatabasesRequest.Builder builder = ListDatabasesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            try {
                result = timestreamWriteClient.listDatabases((ListDatabasesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Databases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createTable(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateTableRequest) {
                CreateTableResponse result;
                CreateTableRequest request = (CreateTableRequest)payload;
                try {
                    result = timestreamWriteClient.createTable(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateTableResponse result;
            RetentionProperties properties;
            CreateTableRequest.Builder builder = CreateTableRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String tableName = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                builder.tableName(tableName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableSchema"))) {
                Schema schema = (Schema)exchange.getIn().getHeader("CamelAwsTimestreamTableSchema", Schema.class);
                builder.schema(schema);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamRetentionProperties"))) {
                properties = (RetentionProperties)exchange.getIn().getHeader("CamelAwsTimestreamRetentionProperties", RetentionProperties.class);
                builder.retentionProperties(properties);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMagneticStoreWriteProperties"))) {
                properties = (MagneticStoreWriteProperties)exchange.getIn().getHeader("CamelAwsTimestreamMagneticStoreWriteProperties", MagneticStoreWriteProperties.class);
                builder.magneticStoreWriteProperties((MagneticStoreWriteProperties)properties);
            }
            try {
                result = timestreamWriteClient.createTable((CreateTableRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteTable(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteTableRequest) {
                DeleteTableResponse result;
                DeleteTableRequest request = (DeleteTableRequest)payload;
                try {
                    result = timestreamWriteClient.deleteTable(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteTableResponse result;
            DeleteTableRequest.Builder builder = DeleteTableRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String tableName = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                builder.tableName(tableName);
            }
            try {
                result = timestreamWriteClient.deleteTable((DeleteTableRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeTable(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeTableRequest) {
                DescribeTableResponse result;
                DescribeTableRequest request = (DescribeTableRequest)payload;
                try {
                    result = timestreamWriteClient.describeTable(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeTableResponse result;
            DescribeTableRequest.Builder builder = DescribeTableRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String tableName = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                builder.tableName(tableName);
            }
            try {
                result = timestreamWriteClient.describeTable((DescribeTableRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateTable(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateTableRequest) {
                UpdateTableResponse result;
                UpdateTableRequest request = (UpdateTableRequest)payload;
                try {
                    result = timestreamWriteClient.updateTable(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateTableResponse result;
            RetentionProperties properties;
            UpdateTableRequest.Builder builder = UpdateTableRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String tableName = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                builder.tableName(tableName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableSchema"))) {
                Schema schema = (Schema)exchange.getIn().getHeader("CamelAwsTimestreamTableSchema", Schema.class);
                builder.schema(schema);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamRetentionProperties"))) {
                properties = (RetentionProperties)exchange.getIn().getHeader("CamelAwsTimestreamRetentionProperties", RetentionProperties.class);
                builder.retentionProperties(properties);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMagneticStoreWriteProperties"))) {
                properties = (MagneticStoreWriteProperties)exchange.getIn().getHeader("CamelAwsTimestreamMagneticStoreWriteProperties", MagneticStoreWriteProperties.class);
                builder.magneticStoreWriteProperties((MagneticStoreWriteProperties)properties);
            }
            try {
                result = timestreamWriteClient.updateTable((UpdateTableRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listTables(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListTablesRequest) {
                ListTablesResponse result;
                ListTablesRequest request = (ListTablesRequest)payload;
                try {
                    result = timestreamWriteClient.listTables(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Tables command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListTablesResponse result;
            ListTablesRequest.Builder builder = ListTablesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTimestreamMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            try {
                result = timestreamWriteClient.listTables((ListTablesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Tables command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void writeRecords(TimestreamWriteClient timestreamWriteClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof WriteRecordsRequest) {
                WriteRecordsResponse result;
                WriteRecordsRequest request = (WriteRecordsRequest)payload;
                try {
                    result = timestreamWriteClient.writeRecords(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Write Records command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            WriteRecordsResponse result;
            WriteRecordsRequest.Builder builder = WriteRecordsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName"))) {
                String dbName = (String)exchange.getIn().getHeader("CamelAwsTimestreamDatabaseName", String.class);
                builder.databaseName(dbName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamTableName"))) {
                String tableName = (String)exchange.getIn().getHeader("CamelAwsTimestreamTableName", String.class);
                builder.tableName(tableName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamRecord"))) {
                Record recordObject = (Record)exchange.getIn().getHeader("CamelAwsTimestreamRecord", Record.class);
                builder.commonAttributes(recordObject);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsTimestreamRecordList"))) {
                List records = (List)exchange.getIn().getHeader("CamelAwsTimestreamRecordList", List.class);
                builder.records((Collection)records);
            }
            try {
                result = timestreamWriteClient.writeRecords((WriteRecordsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Write Records command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Timestream2WriteProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) throws InvalidPayloadException {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new Timestream2WriteProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

