/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.stepfunctions.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Configuration;
import org.apache.camel.component.aws2.stepfunctions.client.StepFunctions2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.SfnClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class StepFunctions2ClientStandardImpl
implements StepFunctions2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(StepFunctions2ClientStandardImpl.class);
    private StepFunctions2Configuration configuration;

    public StepFunctions2ClientStandardImpl(StepFunctions2Configuration configuration) {
        LOG.trace("Creating an AWS StepFunctions manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public SfnClient getSfnClient() {
        SfnClient client = null;
        SfnClientBuilder clientBuilder = SfnClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (SfnClientBuilder)((SfnClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (SfnClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (SfnClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (SfnClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (SfnClient)clientBuilder.build();
        return client;
    }
}

