/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.stepfunctions;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Configuration;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-step-functions")
public class StepFunctions2Component
extends HealthCheckComponent {
    @Metadata
    private StepFunctions2Configuration configuration = new StepFunctions2Configuration();

    public StepFunctions2Component() {
        this(null);
    }

    public StepFunctions2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        StepFunctions2Configuration configuration = this.configuration != null ? this.configuration.copy() : new StepFunctions2Configuration();
        StepFunctions2Endpoint endpoint = new StepFunctions2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && configuration.getAwsSfnClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon step functions client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public StepFunctions2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StepFunctions2Configuration configuration) {
        this.configuration = configuration;
    }
}

