/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.stepfunctions;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Configuration;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Endpoint;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Operations;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.CreateActivityRequest;
import software.amazon.awssdk.services.sfn.model.CreateActivityResponse;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DeleteActivityRequest;
import software.amazon.awssdk.services.sfn.model.DeleteActivityResponse;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DeleteStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.DescribeActivityRequest;
import software.amazon.awssdk.services.sfn.model.DescribeActivityResponse;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskRequest;
import software.amazon.awssdk.services.sfn.model.GetActivityTaskResponse;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest;
import software.amazon.awssdk.services.sfn.model.GetExecutionHistoryResponse;
import software.amazon.awssdk.services.sfn.model.ListActivitiesRequest;
import software.amazon.awssdk.services.sfn.model.ListActivitiesResponse;
import software.amazon.awssdk.services.sfn.model.ListExecutionsRequest;
import software.amazon.awssdk.services.sfn.model.ListExecutionsResponse;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesResponse;
import software.amazon.awssdk.services.sfn.model.StartExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StartSyncExecutionResponse;
import software.amazon.awssdk.services.sfn.model.StateMachineType;
import software.amazon.awssdk.services.sfn.model.StopExecutionRequest;
import software.amazon.awssdk.services.sfn.model.StopExecutionResponse;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest;
import software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse;

public class StepFunctions2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(StepFunctions2Producer.class);
    private transient String sfnProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public StepFunctions2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case createStateMachine: {
                this.createStateMachine(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case deleteStateMachine: {
                this.deleteStateMachine(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case updateStateMachine: {
                this.updateStateMachine(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case describeStateMachine: {
                this.describeStateMachine(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case listStateMachines: {
                this.listStateMachines(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case createActivity: {
                this.createActivity(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case deleteActivity: {
                this.deleteActivity(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case describeActivity: {
                this.describeActivity(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case getActivityTask: {
                this.getActivityTask(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case listActivities: {
                this.listActivities(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case startExecution: {
                this.startExecution(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case startSyncExecution: {
                this.startSyncExecution(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case stopExecution: {
                this.stopExecution(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case describeExecution: {
                this.describeExecution(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case listExecutions: {
                this.listExecutions(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            case getExecutionHistory: {
                this.getExecutionHistory(this.getEndpoint().getAwsSfnClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private StepFunctions2Operations determineOperation(Exchange exchange) {
        StepFunctions2Operations operation = (StepFunctions2Operations)((Object)exchange.getIn().getHeader("CamelAwsStateMachineOperation", StepFunctions2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected StepFunctions2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.sfnProducerToString == null) {
            this.sfnProducerToString = "StepFunctionsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sfnProducerToString;
    }

    public StepFunctions2Endpoint getEndpoint() {
        return (StepFunctions2Endpoint)super.getEndpoint();
    }

    private void createStateMachine(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateStateMachineRequest) {
                CreateStateMachineResponse result;
                CreateStateMachineRequest request = (CreateStateMachineRequest)payload;
                try {
                    result = sfnClient.createStateMachine(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateStateMachineResponse result;
            CreateStateMachineRequest.Builder builder = CreateStateMachineRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineName"))) {
                String stateMachineName = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineName", String.class);
                builder.name(stateMachineName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineDefinition"))) {
                String stateMachineDefinition = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineDefinition", String.class);
                builder.definition(stateMachineDefinition);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineType"))) {
                if (exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineType") instanceof StateMachineType) {
                    stateMachineType = (StateMachineType)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineType", StateMachineType.class);
                    builder.type(stateMachineType);
                } else {
                    stateMachineType = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineType", String.class);
                    builder.type((String)stateMachineType);
                }
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineRoleArn"))) {
                String stateMachineRoleArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineRoleArn", String.class);
                builder.roleArn(stateMachineRoleArn);
            }
            try {
                result = sfnClient.createStateMachine((CreateStateMachineRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteStateMachine(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteStateMachineRequest) {
                DeleteStateMachineResponse result;
                DeleteStateMachineRequest request = (DeleteStateMachineRequest)payload;
                try {
                    result = sfnClient.deleteStateMachine(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteStateMachineResponse result;
            DeleteStateMachineRequest.Builder builder = DeleteStateMachineRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn", String.class);
                builder.stateMachineArn(stateMachineArn);
            }
            try {
                DeleteStateMachineRequest request = (DeleteStateMachineRequest)builder.build();
                result = sfnClient.deleteStateMachine(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateStateMachine(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateStateMachineRequest) {
                UpdateStateMachineResponse result;
                UpdateStateMachineRequest request = (UpdateStateMachineRequest)payload;
                try {
                    result = sfnClient.updateStateMachine(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateStateMachineResponse result;
            UpdateStateMachineRequest.Builder builder = UpdateStateMachineRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn", String.class);
                builder.stateMachineArn(stateMachineArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineDefinition"))) {
                String stateMachineDefinition = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineDefinition", String.class);
                builder.definition(stateMachineDefinition);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineRoleArn"))) {
                String stateMachineRoleArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineRoleArn", String.class);
                builder.roleArn(stateMachineRoleArn);
            }
            try {
                result = sfnClient.updateStateMachine((UpdateStateMachineRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeStateMachine(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeStateMachineRequest) {
                DescribeStateMachineResponse result;
                DescribeStateMachineRequest request = (DescribeStateMachineRequest)payload;
                try {
                    result = sfnClient.describeStateMachine(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeStateMachineResponse result;
            DescribeStateMachineRequest.Builder builder = DescribeStateMachineRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn", String.class);
                builder.stateMachineArn(stateMachineArn);
            }
            try {
                result = sfnClient.describeStateMachine((DescribeStateMachineRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe State Machine command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listStateMachines(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListStateMachinesRequest) {
                ListStateMachinesResponse result;
                ListStateMachinesRequest request = (ListStateMachinesRequest)payload;
                try {
                    result = sfnClient.listStateMachines(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List State Machines command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListStateMachinesResponse result;
            ListStateMachinesRequest.Builder builder = ListStateMachinesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachinesMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsStateMachinesMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            try {
                result = sfnClient.listStateMachines((ListStateMachinesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List State Machines command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createActivity(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateActivityRequest) {
                CreateActivityResponse result;
                CreateActivityRequest request = (CreateActivityRequest)payload;
                try {
                    result = sfnClient.createActivity(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateActivityResponse result;
            CreateActivityRequest.Builder builder = CreateActivityRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityName"))) {
                String activityName = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityName", String.class);
                builder.name(activityName);
            }
            try {
                result = sfnClient.createActivity((CreateActivityRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteActivity(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteActivityRequest) {
                DeleteActivityResponse result;
                DeleteActivityRequest request = (DeleteActivityRequest)payload;
                try {
                    result = sfnClient.deleteActivity(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteActivityResponse result;
            DeleteActivityRequest.Builder builder = DeleteActivityRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn"))) {
                String activityArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn", String.class);
                builder.activityArn(activityArn);
            }
            try {
                result = sfnClient.deleteActivity((DeleteActivityRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeActivity(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeActivityRequest) {
                DescribeActivityResponse result;
                DescribeActivityRequest request = (DescribeActivityRequest)payload;
                try {
                    result = sfnClient.describeActivity(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeActivityResponse result;
            DescribeActivityRequest.Builder builder = DescribeActivityRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn"))) {
                String activityArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn", String.class);
                builder.activityArn(activityArn);
            }
            try {
                result = sfnClient.describeActivity((DescribeActivityRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Activity command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getActivityTask(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetActivityTaskRequest) {
                GetActivityTaskResponse result;
                GetActivityTaskRequest request = (GetActivityTaskRequest)payload;
                try {
                    result = sfnClient.getActivityTask(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Activity Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetActivityTaskResponse result;
            GetActivityTaskRequest.Builder builder = GetActivityTaskRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn"))) {
                String activityArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineActivityArn", String.class);
                builder.activityArn(activityArn);
            }
            try {
                result = sfnClient.getActivityTask((GetActivityTaskRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Activity Task command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listActivities(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListActivitiesRequest) {
                ListActivitiesResponse result;
                ListActivitiesRequest request = (ListActivitiesRequest)payload;
                try {
                    result = sfnClient.listActivities(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Activities command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListActivitiesResponse result;
            ListActivitiesRequest.Builder builder = ListActivitiesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineActivitiesMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsStateMachineActivitiesMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            try {
                result = sfnClient.listActivities((ListActivitiesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Activities command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startExecution(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartExecutionRequest) {
                StartExecutionResponse result;
                StartExecutionRequest request = (StartExecutionRequest)payload;
                try {
                    result = sfnClient.startExecution(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartExecutionResponse result;
            StartExecutionRequest.Builder builder = StartExecutionRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn", String.class);
                builder.stateMachineArn(stateMachineArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionName"))) {
                String executionName = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionName", String.class);
                builder.name(executionName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionInput"))) {
                String executionInput = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionInput", String.class);
                builder.input(executionInput);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionTraceHeader"))) {
                String executionTraceHeader = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionTraceHeader", String.class);
                builder.traceHeader(executionTraceHeader);
            }
            try {
                result = sfnClient.startExecution((StartExecutionRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startSyncExecution(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartSyncExecutionRequest) {
                StartSyncExecutionResponse result;
                StartSyncExecutionRequest request = (StartSyncExecutionRequest)payload;
                try {
                    result = sfnClient.startSyncExecution(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Sync Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartSyncExecutionResponse result;
            StartSyncExecutionRequest.Builder builder = StartSyncExecutionRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStepFunctionsStateMachineArn", String.class);
                builder.stateMachineArn(stateMachineArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionName"))) {
                String executionName = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionName", String.class);
                builder.name(executionName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionInput"))) {
                String executionInput = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionInput", String.class);
                builder.input(executionInput);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionTraceHeader"))) {
                String executionTraceHeader = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionTraceHeader", String.class);
                builder.traceHeader(executionTraceHeader);
            }
            try {
                result = sfnClient.startSyncExecution((StartSyncExecutionRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Sync Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void stopExecution(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StopExecutionRequest) {
                StopExecutionResponse result;
                StopExecutionRequest request = (StopExecutionRequest)payload;
                try {
                    result = sfnClient.stopExecution(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Stop Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StopExecutionResponse result;
            StopExecutionRequest.Builder builder = StopExecutionRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn", String.class);
                builder.executionArn(stateMachineArn);
            }
            try {
                result = sfnClient.stopExecution((StopExecutionRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Stop Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeExecution(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeExecutionRequest) {
                DescribeExecutionResponse result;
                DescribeExecutionRequest request = (DescribeExecutionRequest)payload;
                try {
                    result = sfnClient.describeExecution(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeExecutionResponse result;
            DescribeExecutionRequest.Builder builder = DescribeExecutionRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn"))) {
                String stateMachineArn = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn", String.class);
                builder.executionArn(stateMachineArn);
            }
            try {
                result = sfnClient.describeExecution((DescribeExecutionRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Execution command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listExecutions(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListExecutionsRequest) {
                ListExecutionsResponse result;
                ListExecutionsRequest request = (ListExecutionsRequest)payload;
                try {
                    result = sfnClient.listExecutions(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Executions command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListExecutionsResponse result;
            ListExecutionsRequest.Builder builder = ListExecutionsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsStateMachineExecutionMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            try {
                result = sfnClient.listExecutions((ListExecutionsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Executions command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getExecutionHistory(SfnClient sfnClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetExecutionHistoryRequest) {
                GetExecutionHistoryResponse result;
                GetExecutionHistoryRequest request = (GetExecutionHistoryRequest)payload;
                try {
                    result = sfnClient.getExecutionHistory(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Execution History command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = StepFunctions2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetExecutionHistoryResponse result;
            GetExecutionHistoryRequest.Builder builder = GetExecutionHistoryRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn"))) {
                String executionArn = (String)exchange.getIn().getHeader("CamelAwsStateMachineExecutionArn", String.class);
                builder.executionArn(executionArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryIncludeExecutionData"))) {
                boolean includeExecutionData = (Boolean)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryIncludeExecutionData", Boolean.class);
                builder.includeExecutionData(Boolean.valueOf(includeExecutionData));
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryReverseOrder"))) {
                Boolean executionReverseOrder = (Boolean)exchange.getIn().getHeader("CamelAwsStateMachineExecutionHistoryReverseOrder", Boolean.class);
                builder.reverseOrder(executionReverseOrder);
            }
            try {
                result = sfnClient.getExecutionHistory((GetExecutionHistoryRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Execution History command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = StepFunctions2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new StepFunctions2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

