/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.sns.ConstantMessageGroupIdStrategy;
import org.apache.camel.component.aws2.sns.ExchangeIdMessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sns.ExchangeIdMessageGroupIdStrategy;
import org.apache.camel.component.aws2.sns.MessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sns.MessageGroupIdStrategy;
import org.apache.camel.component.aws2.sns.NullMessageDeduplicationIdStrategy;
import org.apache.camel.component.aws2.sns.PropertyValueMessageGroupIdStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.sns.SnsClient;

@UriParams
public class Sns2Configuration
implements Cloneable {
    private String topicArn;
    private String topicName;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private SnsClient amazonSNSClient;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam(label="security", secret=true)
    private String sessionToken;
    @UriParam(label="proxy", enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(label="proxy")
    private String proxyHost;
    @UriParam(label="proxy")
    private Integer proxyPort;
    @UriParam
    private String queueArn;
    @UriParam
    private boolean subscribeSNStoSQS;
    @UriParam
    private String kmsMasterKeyId;
    @UriParam
    private boolean serverSideEncryptionEnabled;
    @UriParam
    private boolean autoCreateTopic;
    @UriParam
    private boolean overrideEndpoint;
    @UriParam
    private String uriEndpointOverride;
    @UriParam
    private String subject;
    @UriParam
    @Metadata(supportFileReference=true)
    private String policy;
    @UriParam
    private String messageStructure;
    @UriParam(enums="ap-south-2,ap-south-1,eu-south-1,eu-south-2,us-gov-east-1,me-central-1,il-central-1,ca-central-1,eu-central-1,us-iso-west-1,eu-central-2,us-west-1,us-west-2,af-south-1,eu-north-1,eu-west-3,eu-west-2,eu-west-1,ap-northeast-3,ap-northeast-2,ap-northeast-1,me-south-1,sa-east-1,ap-east-1,cn-north-1,us-gov-west-1,ap-southeast-1,ap-southeast-2,us-iso-east-1,ap-southeast-3,ap-southeast-4,us-east-1,us-east-2,cn-northwest-1,us-isob-east-1,aws-global,aws-cn-global,aws-us-gov-global,aws-iso-global,aws-iso-b-global")
    private String region;
    @UriParam(label="security")
    private boolean trustAllCertificates;
    @UriParam(label="security")
    private boolean useDefaultCredentialsProvider;
    @UriParam(label="security")
    private boolean useProfileCredentialsProvider;
    @UriParam(label="security")
    private boolean useSessionCredentials;
    @UriParam(label="security")
    private String profileCredentialsName;
    @UriParam(label="producer", javaType="java.lang.String", enums="useConstant,useExchangeId,usePropertyValue")
    private MessageGroupIdStrategy messageGroupIdStrategy;
    @UriParam(label="producer", javaType="java.lang.String", defaultValue="useExchangeId", enums="useExchangeId,useContentBasedDeduplication")
    private MessageDeduplicationIdStrategy messageDeduplicationIdStrategy = new ExchangeIdMessageDeduplicationIdStrategy();

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public SnsClient getAmazonSNSClient() {
        return this.amazonSNSClient;
    }

    public void setAmazonSNSClient(SnsClient amazonSNSClient) {
        this.amazonSNSClient = amazonSNSClient;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getMessageStructure() {
        return this.messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getQueueArn() {
        return this.queueArn;
    }

    public void setQueueArn(String queueArn) {
        this.queueArn = queueArn;
    }

    public boolean isSubscribeSNStoSQS() {
        return this.subscribeSNStoSQS;
    }

    public void setSubscribeSNStoSQS(boolean subscribeSNStoSQS) {
        this.subscribeSNStoSQS = subscribeSNStoSQS;
    }

    public String getKmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public void setKmsMasterKeyId(String kmsMasterKeyId) {
        this.kmsMasterKeyId = kmsMasterKeyId;
    }

    public boolean isServerSideEncryptionEnabled() {
        return this.serverSideEncryptionEnabled;
    }

    public void setServerSideEncryptionEnabled(boolean serverSideEncryptionEnabled) {
        this.serverSideEncryptionEnabled = serverSideEncryptionEnabled;
    }

    public boolean isAutoCreateTopic() {
        return this.autoCreateTopic;
    }

    public void setAutoCreateTopic(boolean autoCreateTopic) {
        this.autoCreateTopic = autoCreateTopic;
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    public boolean isUseDefaultCredentialsProvider() {
        return this.useDefaultCredentialsProvider;
    }

    public void setUseDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
        this.useDefaultCredentialsProvider = useDefaultCredentialsProvider;
    }

    public void setUseProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
        this.useProfileCredentialsProvider = useProfileCredentialsProvider;
    }

    public boolean isUseProfileCredentialsProvider() {
        return this.useProfileCredentialsProvider;
    }

    public boolean isUseSessionCredentials() {
        return this.useSessionCredentials;
    }

    public void setUseSessionCredentials(boolean useSessionCredentials) {
        this.useSessionCredentials = useSessionCredentials;
    }

    public String getProfileCredentialsName() {
        return this.profileCredentialsName;
    }

    public void setProfileCredentialsName(String profileCredentialsName) {
        this.profileCredentialsName = profileCredentialsName;
    }

    public void setMessageGroupIdStrategy(String strategy) {
        if ("useConstant".equalsIgnoreCase(strategy)) {
            this.messageGroupIdStrategy = new ConstantMessageGroupIdStrategy();
        } else if ("useExchangeId".equalsIgnoreCase(strategy)) {
            this.messageGroupIdStrategy = new ExchangeIdMessageGroupIdStrategy();
        } else if ("usePropertyValue".equalsIgnoreCase(strategy)) {
            this.messageGroupIdStrategy = new PropertyValueMessageGroupIdStrategy();
        } else {
            throw new IllegalArgumentException("Unrecognised MessageGroupIdStrategy: " + strategy);
        }
    }

    public void setMessageGroupIdStrategy(MessageGroupIdStrategy messageGroupIdStrategy) {
        this.messageGroupIdStrategy = messageGroupIdStrategy;
    }

    public MessageGroupIdStrategy getMessageGroupIdStrategy() {
        return this.messageGroupIdStrategy;
    }

    public MessageDeduplicationIdStrategy getMessageDeduplicationIdStrategy() {
        return this.messageDeduplicationIdStrategy;
    }

    public void setMessageDeduplicationIdStrategy(String strategy) {
        if ("useExchangeId".equalsIgnoreCase(strategy)) {
            this.messageDeduplicationIdStrategy = new ExchangeIdMessageDeduplicationIdStrategy();
        } else if ("useContentBasedDeduplication".equalsIgnoreCase(strategy)) {
            this.messageDeduplicationIdStrategy = new NullMessageDeduplicationIdStrategy();
        } else {
            throw new IllegalArgumentException("Unrecognised MessageDeduplicationIdStrategy: " + strategy);
        }
    }

    public void setMessageDeduplicationIdStrategy(MessageDeduplicationIdStrategy messageDeduplicationIdStrategy) {
        this.messageDeduplicationIdStrategy = messageDeduplicationIdStrategy;
    }

    public boolean isOverrideEndpoint() {
        return this.overrideEndpoint;
    }

    public void setOverrideEndpoint(boolean overrideEndpoint) {
        this.overrideEndpoint = overrideEndpoint;
    }

    public String getUriEndpointOverride() {
        return this.uriEndpointOverride;
    }

    public void setUriEndpointOverride(String uriEndpointOverride) {
        this.uriEndpointOverride = uriEndpointOverride;
    }

    public Sns2Configuration copy() {
        try {
            return (Sns2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    boolean isFifoTopic() {
        if (ObjectHelper.isNotEmpty((String)this.topicName) && this.topicName.endsWith(".fifo")) {
            return true;
        }
        if (ObjectHelper.isNotEmpty((String)this.topicArn)) {
            return this.topicArn.endsWith(".fifo");
        }
        return false;
    }
}

