/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.stream;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Endpoint;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.component.aws2.s3.utils.AWS2S3Utils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

public class AWS2S3StreamUploadProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWS2S3StreamUploadProducer.class);
    private static final String TIMEOUT_CHECKER_EXECUTOR_NAME = "S3_Streaming_Upload_Timeout_Checker";
    private AtomicInteger part = new AtomicInteger();
    private UploadState uploadAggregate = null;
    private final Object lock = new Object();
    private transient String s3ProducerToString;
    private ScheduledExecutorService timeoutCheckerExecutorService;

    public AWS2S3StreamUploadProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().getStreamingUploadTimeout() > 0L) {
            this.timeoutCheckerExecutorService = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, TIMEOUT_CHECKER_EXECUTOR_NAME);
            this.timeoutCheckerExecutorService.scheduleAtFixedRate(new StreamingUploadTimeoutTask(), this.getConfiguration().getStreamingUploadTimeout(), this.getConfiguration().getStreamingUploadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.getConfiguration().getRestartingPolicy().equals((Object)AWSS3RestartingPolicyEnum.lastPart)) {
            this.setStartingPart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (ObjectHelper.isNotEmpty((Object)this.uploadAggregate)) {
                this.uploadPart(this.uploadAggregate);
                this.completeUpload(this.uploadAggregate);
            }
        }
        if (this.timeoutCheckerExecutorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Object object;
        byte[] b;
        int maxRead;
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        UploadState state = null;
        int totalSize = 0;
        int n = maxRead = this.getConfiguration().isMultiPartUpload() ? Math.toIntExact(this.getConfiguration().getPartSize()) : this.getConfiguration().getBufferSize();
        if (this.uploadAggregate != null) {
            ++this.uploadAggregate.index;
            maxRead -= this.uploadAggregate.buffer.size();
        }
        while ((b = AWS2S3Utils.toByteArray(is, maxRead)).length > 0) {
            BucketCannedACL acl;
            String cannedAcl;
            totalSize += b.length;
            if (this.getConfiguration().isMultiPartUpload()) {
                maxRead -= b.length;
            }
            object = this.lock;
            synchronized (object) {
                if (ObjectHelper.isNotEmpty((Object)this.uploadAggregate)) {
                    this.uploadAggregate.buffer.write(b);
                    if (this.getConfiguration().isMultiPartUpload() && (long)this.uploadAggregate.buffer.size() >= this.getConfiguration().getPartSize()) {
                        this.uploadPart(this.uploadAggregate);
                        maxRead = Math.toIntExact(this.getConfiguration().getPartSize());
                        continue;
                    }
                    if (this.uploadAggregate.buffer.size() >= this.getConfiguration().getBatchSize() || this.uploadAggregate.index >= this.getConfiguration().getBatchMessageNumber() && (long)this.uploadAggregate.buffer.size() < this.getConfiguration().getPartSize()) {
                        if (this.uploadAggregate.buffer.size() > 0) {
                            this.uploadPart(this.uploadAggregate);
                        }
                        CompleteMultipartUploadResponse uploadResult = this.completeUpload(this.uploadAggregate);
                        this.uploadAggregate = null;
                        Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                        message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
                        if (uploadResult.versionId() != null) {
                            message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
                        }
                    }
                    continue;
                }
            }
            if (state == null) {
                state = new UploadState();
            } else {
                state.index = 1;
            }
            state.buffer.write(b);
            String keyName = this.getConfiguration().getKeyName();
            String fileName = AWS2S3Utils.determineFileName(keyName);
            String extension = AWS2S3Utils.determineFileExtension(keyName);
            if (state.index == 1 && this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.random)) {
                state.id = UUID.randomUUID();
            }
            state.dynamicKeyName = this.fileNameToUpload(fileName, this.getConfiguration().getNamingStrategy(), extension, state.part, state.id);
            CreateMultipartUploadRequest.Builder createMultipartUploadRequest = CreateMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName);
            String storageClass = AWS2S3Utils.determineStorageClass(exchange, this.getConfiguration());
            if (storageClass != null) {
                createMultipartUploadRequest.storageClass(storageClass);
            }
            if ((cannedAcl = (String)exchange.getIn().getHeader("CamelAwsS3CannedAcl", String.class)) != null) {
                ObjectCannedACL objectAcl = ObjectCannedACL.valueOf((String)cannedAcl);
                createMultipartUploadRequest.acl(objectAcl);
            }
            if ((acl = (BucketCannedACL)exchange.getIn().getHeader("CamelAwsS3Acl", BucketCannedACL.class)) != null) {
                createMultipartUploadRequest.acl(acl.toString());
            }
            AWS2S3Utils.setEncryption(createMultipartUploadRequest, this.getConfiguration());
            LOG.trace("Initiating multipart upload [{}] from exchange [{}]...", (Object)createMultipartUploadRequest, (Object)exchange);
            if (state.index == 1) {
                state.initResponse = this.getEndpoint().getS3Client().createMultipartUpload((CreateMultipartUploadRequest)createMultipartUploadRequest.build());
            }
            try {
                if (totalSize >= this.getConfiguration().getBatchSize() || state.buffer.size() >= this.getConfiguration().getBatchSize() || state.index >= this.getConfiguration().getBatchMessageNumber()) {
                    this.uploadPart(state);
                    CompleteMultipartUploadResponse uploadResult = this.completeUpload(state);
                    Message message = AWS2S3StreamUploadProducer.getMessageForResponse(exchange);
                    message.setHeader("CamelAwsS3ETag", (Object)uploadResult.eTag());
                    if (uploadResult.versionId() != null) {
                        message.setHeader("CamelAwsS3VersionId", (Object)uploadResult.versionId());
                    }
                    state = null;
                    continue;
                }
                if (!this.getConfiguration().isMultiPartUpload() || (long)state.buffer.size() < this.getConfiguration().getPartSize()) continue;
                this.uploadPart(state);
                maxRead = Math.toIntExact(this.getConfiguration().getPartSize());
            }
            catch (Exception e) {
                this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build());
                throw e;
            }
        }
        if (ObjectHelper.isNotEmpty(state)) {
            object = this.lock;
            synchronized (object) {
                if (ObjectHelper.isEmpty((Object)this.uploadAggregate)) {
                    this.uploadAggregate = state;
                } else {
                    this.uploadAggregate.buffer.write(state.buffer.toByteArray());
                }
            }
        }
    }

    private CompleteMultipartUploadResponse completeUpload(UploadState state) {
        CompletedMultipartUpload completeMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(state.completedParts).build();
        CompleteMultipartUploadRequest compRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().multipartUpload(completeMultipartUpload).bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build();
        try {
            CompleteMultipartUploadResponse uploadResult = this.getEndpoint().getS3Client().completeMultipartUpload(compRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed upload for the part {}, multipart {} with etag {} at index {}", new Object[]{this.part, state.multipartIndex, uploadResult.eTag(), state.index});
            }
            this.part.getAndIncrement();
            return uploadResult;
        }
        catch (Exception e) {
            LOG.warn("Error completing multipart upload - Multipart upload will be aborted", (Throwable)e);
            this.getEndpoint().getS3Client().abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).build());
            throw e;
        }
    }

    private void uploadPart(UploadState state) {
        UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.getConfiguration().getBucketName()).key(state.dynamicKeyName).uploadId(state.initResponse.uploadId()).partNumber(Integer.valueOf(state.multipartIndex)).build();
        LOG.trace("Uploading part {}, multipart {} at index {} for {}", new Object[]{state.part, state.multipartIndex, state.index, this.getConfiguration().getKeyName()});
        String etag = this.getEndpoint().getS3Client().uploadPart(uploadRequest, RequestBody.fromBytes((byte[])state.buffer.toByteArray())).eTag();
        CompletedPart partUpload = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(state.multipartIndex)).eTag(etag).build();
        state.completedParts.add(partUpload);
        state.buffer.reset();
        ++state.multipartIndex;
    }

    private String fileNameToUpload(String fileName, AWSS3NamingStrategyEnum strategy, String ext, int part, UUID id) {
        return switch (strategy) {
            case AWSS3NamingStrategyEnum.progressive -> {
                if (part > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        yield fileName + "-" + part + ext;
                    }
                    yield fileName + "-" + part;
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    yield fileName + ext;
                }
                yield fileName;
            }
            case AWSS3NamingStrategyEnum.random -> {
                if (part > 0) {
                    if (ObjectHelper.isNotEmpty((String)ext)) {
                        yield fileName + "-" + id.toString() + ext;
                    }
                    yield fileName + "-" + id.toString();
                }
                if (ObjectHelper.isNotEmpty((String)ext)) {
                    yield fileName + ext;
                }
                yield fileName;
            }
            default -> throw new IllegalArgumentException("Unsupported operation");
        };
    }

    private void setStartingPart() {
        if (this.getConfiguration().getNamingStrategy().equals((Object)AWSS3NamingStrategyEnum.progressive)) {
            ArrayList<S3Object> list = new ArrayList<S3Object>();
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.getConfiguration().getBucketName()).prefix(AWS2S3Utils.determineFileName(this.getConfiguration().getKeyName())).build();
            ListObjectsV2Iterable listRes = this.getEndpoint().getS3Client().listObjectsV2Paginator(request);
            listRes.stream().flatMap(r -> r.contents().stream()).forEach(content -> list.add((S3Object)content));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(S3Object::lastModified));
                int listSize = list.size();
                String fileName = AWS2S3Utils.determineFileName(((S3Object)list.get(listSize - 1)).key());
                int position = fileName.lastIndexOf("-");
                if (position != -1) {
                    String partString = fileName.substring(position + 1);
                    if (ObjectHelper.isNotEmpty((String)partString)) {
                        this.part.getAndSet(Integer.parseInt(partString) + 1);
                    }
                } else {
                    this.part.getAndSet(1);
                }
            }
        } else {
            LOG.info("lastPart restarting policy can be used only with progressive naming strategy");
        }
    }

    protected AWS2S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.s3ProducerToString == null) {
            this.s3ProducerToString = "AWS2S3StreamUploadProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.s3ProducerToString;
    }

    public AWS2S3Endpoint getEndpoint() {
        return (AWS2S3Endpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private class UploadState {
        int index = 1;
        int multipartIndex = 1;
        int part;
        List<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        ByteArrayOutputStream buffer;
        String dynamicKeyName;
        UUID id;
        CreateMultipartUploadResponse initResponse;

        UploadState() {
            this.part = AWS2S3StreamUploadProducer.this.part.get();
            this.buffer = new ByteArrayOutputStream();
        }
    }

    private final class StreamingUploadTimeoutTask
    implements Runnable {
        private StreamingUploadTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AWS2S3StreamUploadProducer.this.lock;
            synchronized (object) {
                if (ObjectHelper.isNotEmpty((Object)AWS2S3StreamUploadProducer.this.uploadAggregate)) {
                    AWS2S3StreamUploadProducer.this.uploadPart(AWS2S3StreamUploadProducer.this.uploadAggregate);
                    AWS2S3StreamUploadProducer.this.completeUpload(AWS2S3StreamUploadProducer.this.uploadAggregate);
                    AWS2S3StreamUploadProducer.this.uploadAggregate = null;
                }
            }
        }
    }
}

