/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="aws2-s3:application-cloudevents", description="Adds CloudEvent headers to the Camel message with AWS S3 get object response details")
public class AWS2S3CloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.aws.s3.getObject");
        if (message.getHeaders().containsKey("CamelAwsS3BucketName")) {
            headers.put("CamelCloudEventSource", "aws.s3.bucket." + (String)message.getHeader("CamelAwsS3BucketName", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAwsS3Key", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

