/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.s3.AWS2S3Component;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public class AWS2S3ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private AWS2S3Configuration getOrCreateConfiguration(AWS2S3Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AWS2S3Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AWS2S3Component target = (AWS2S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                this.getOrCreateConfiguration(target).setAmazonS3Client((S3Client)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, S3Client.class, (Object)value));
                return true;
            }
            case "amazons3presigner": 
            case "amazonS3Presigner": {
                this.getOrCreateConfiguration(target).setAmazonS3Presigner((S3Presigner)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, S3Presigner.class, (Object)value));
                return true;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                this.getOrCreateConfiguration(target).setAutocloseBody((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                this.getOrCreateConfiguration(target).setAwsKMSKeyId((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "batchmessagenumber": 
            case "batchMessageNumber": {
                this.getOrCreateConfiguration(target).setBatchMessageNumber((Integer)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchsize": 
            case "batchSize": {
                this.getOrCreateConfiguration(target).setBatchSize((Integer)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((AWS2S3Configuration)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWS2S3Configuration.class, (Object)value));
                return true;
            }
            case "customeralgorithm": 
            case "customerAlgorithm": {
                this.getOrCreateConfiguration(target).setCustomerAlgorithm((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customerkeyid": 
            case "customerKeyId": {
                this.getOrCreateConfiguration(target).setCustomerKeyId((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customerkeymd5": 
            case "customerKeyMD5": {
                this.getOrCreateConfiguration(target).setCustomerKeyMD5((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                this.getOrCreateConfiguration(target).setDeleteAfterWrite((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                this.getOrCreateConfiguration(target).setDestinationBucket((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "destinationbucketprefix": 
            case "destinationBucketPrefix": {
                this.getOrCreateConfiguration(target).setDestinationBucketPrefix((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "destinationbucketsuffix": 
            case "destinationBucketSuffix": {
                this.getOrCreateConfiguration(target).setDestinationBucketSuffix((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "donefilename": 
            case "doneFileName": {
                this.getOrCreateConfiguration(target).setDoneFileName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filename": 
            case "fileName": {
                this.getOrCreateConfiguration(target).setFileName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forcepathstyle": 
            case "forcePathStyle": {
                this.getOrCreateConfiguration(target).setForcePathStyle((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "ignorebody": 
            case "ignoreBody": {
                this.getOrCreateConfiguration(target).setIgnoreBody((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includefolders": 
            case "includeFolders": {
                this.getOrCreateConfiguration(target).setIncludeFolders((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyname": 
            case "keyName": {
                this.getOrCreateConfiguration(target).setKeyName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                this.getOrCreateConfiguration(target).setMoveAfterRead((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                this.getOrCreateConfiguration(target).setMultiPartUpload((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "namingstrategy": 
            case "namingStrategy": {
                this.getOrCreateConfiguration(target).setNamingStrategy((AWSS3NamingStrategyEnum)((Object)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWSS3NamingStrategyEnum.class, (Object)value)));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((AWS2S3Operations)((Object)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWS2S3Operations.class, (Object)value)));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "partsize": 
            case "partSize": {
                this.getOrCreateConfiguration(target).setPartSize((Long)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                this.getOrCreateConfiguration(target).setProfileCredentialsName((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "restartingpolicy": 
            case "restartingPolicy": {
                this.getOrCreateConfiguration(target).setRestartingPolicy((AWSS3RestartingPolicyEnum)((Object)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, AWSS3RestartingPolicyEnum.class, (Object)value)));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "streaminguploadmode": 
            case "streamingUploadMode": {
                this.getOrCreateConfiguration(target).setStreamingUploadMode((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streaminguploadtimeout": 
            case "streamingUploadTimeout": {
                this.getOrCreateConfiguration(target).setStreamingUploadTimeout((Long)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useawskms": 
            case "useAwsKMS": {
                this.getOrCreateConfiguration(target).setUseAwsKMS((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usecustomerkey": 
            case "useCustomerKey": {
                this.getOrCreateConfiguration(target).setUseCustomerKey((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseDefaultCredentialsProvider((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseProfileCredentialsProvider((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usesses3": 
            case "useSSES3": {
                this.getOrCreateConfiguration(target).setUseSSES3((Boolean)AWS2S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"amazonS3Client", "amazonS3Presigner"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return S3Client.class;
            }
            case "amazons3presigner": 
            case "amazonS3Presigner": {
                return S3Presigner.class;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return Boolean.TYPE;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return String.class;
            }
            case "batchmessagenumber": 
            case "batchMessageNumber": {
                return Integer.TYPE;
            }
            case "batchsize": 
            case "batchSize": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return AWS2S3Configuration.class;
            }
            case "customeralgorithm": 
            case "customerAlgorithm": {
                return String.class;
            }
            case "customerkeyid": 
            case "customerKeyId": {
                return String.class;
            }
            case "customerkeymd5": 
            case "customerKeyMD5": {
                return String.class;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return Boolean.TYPE;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return Boolean.TYPE;
            }
            case "delimiter": {
                return String.class;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return String.class;
            }
            case "destinationbucketprefix": 
            case "destinationBucketPrefix": {
                return String.class;
            }
            case "destinationbucketsuffix": 
            case "destinationBucketSuffix": {
                return String.class;
            }
            case "donefilename": 
            case "doneFileName": {
                return String.class;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "forcepathstyle": 
            case "forcePathStyle": {
                return Boolean.TYPE;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "ignorebody": 
            case "ignoreBody": {
                return Boolean.TYPE;
            }
            case "includebody": 
            case "includeBody": {
                return Boolean.TYPE;
            }
            case "includefolders": 
            case "includeFolders": {
                return Boolean.TYPE;
            }
            case "keyname": 
            case "keyName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return Boolean.TYPE;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return Boolean.TYPE;
            }
            case "namingstrategy": 
            case "namingStrategy": {
                return AWSS3NamingStrategyEnum.class;
            }
            case "operation": {
                return AWS2S3Operations.class;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "partsize": 
            case "partSize": {
                return Long.TYPE;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "policy": {
                return String.class;
            }
            case "prefix": {
                return String.class;
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                return String.class;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "restartingpolicy": 
            case "restartingPolicy": {
                return AWSS3RestartingPolicyEnum.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "storageclass": 
            case "storageClass": {
                return String.class;
            }
            case "streaminguploadmode": 
            case "streamingUploadMode": {
                return Boolean.TYPE;
            }
            case "streaminguploadtimeout": 
            case "streamingUploadTimeout": {
                return Long.TYPE;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "useawskms": 
            case "useAwsKMS": {
                return Boolean.TYPE;
            }
            case "usecustomerkey": 
            case "useCustomerKey": {
                return Boolean.TYPE;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return Boolean.TYPE;
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                return Boolean.TYPE;
            }
            case "usesses3": 
            case "useSSES3": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AWS2S3Component target = (AWS2S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return this.getOrCreateConfiguration(target).getAmazonS3Client();
            }
            case "amazons3presigner": 
            case "amazonS3Presigner": {
                return this.getOrCreateConfiguration(target).getAmazonS3Presigner();
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return this.getOrCreateConfiguration(target).isAutocloseBody();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return this.getOrCreateConfiguration(target).getAwsKMSKeyId();
            }
            case "batchmessagenumber": 
            case "batchMessageNumber": {
                return this.getOrCreateConfiguration(target).getBatchMessageNumber();
            }
            case "batchsize": 
            case "batchSize": {
                return this.getOrCreateConfiguration(target).getBatchSize();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "customeralgorithm": 
            case "customerAlgorithm": {
                return this.getOrCreateConfiguration(target).getCustomerAlgorithm();
            }
            case "customerkeyid": 
            case "customerKeyId": {
                return this.getOrCreateConfiguration(target).getCustomerKeyId();
            }
            case "customerkeymd5": 
            case "customerKeyMD5": {
                return this.getOrCreateConfiguration(target).getCustomerKeyMD5();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return this.getOrCreateConfiguration(target).isDeleteAfterWrite();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return this.getOrCreateConfiguration(target).getDestinationBucket();
            }
            case "destinationbucketprefix": 
            case "destinationBucketPrefix": {
                return this.getOrCreateConfiguration(target).getDestinationBucketPrefix();
            }
            case "destinationbucketsuffix": 
            case "destinationBucketSuffix": {
                return this.getOrCreateConfiguration(target).getDestinationBucketSuffix();
            }
            case "donefilename": 
            case "doneFileName": {
                return this.getOrCreateConfiguration(target).getDoneFileName();
            }
            case "filename": 
            case "fileName": {
                return this.getOrCreateConfiguration(target).getFileName();
            }
            case "forcepathstyle": 
            case "forcePathStyle": {
                return this.getOrCreateConfiguration(target).isForcePathStyle();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "ignorebody": 
            case "ignoreBody": {
                return this.getOrCreateConfiguration(target).isIgnoreBody();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "includefolders": 
            case "includeFolders": {
                return this.getOrCreateConfiguration(target).isIncludeFolders();
            }
            case "keyname": 
            case "keyName": {
                return this.getOrCreateConfiguration(target).getKeyName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return this.getOrCreateConfiguration(target).isMoveAfterRead();
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return this.getOrCreateConfiguration(target).isMultiPartUpload();
            }
            case "namingstrategy": 
            case "namingStrategy": {
                return this.getOrCreateConfiguration(target).getNamingStrategy();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "partsize": 
            case "partSize": {
                return this.getOrCreateConfiguration(target).getPartSize();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "profilecredentialsname": 
            case "profileCredentialsName": {
                return this.getOrCreateConfiguration(target).getProfileCredentialsName();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "restartingpolicy": 
            case "restartingPolicy": {
                return this.getOrCreateConfiguration(target).getRestartingPolicy();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "streaminguploadmode": 
            case "streamingUploadMode": {
                return this.getOrCreateConfiguration(target).isStreamingUploadMode();
            }
            case "streaminguploadtimeout": 
            case "streamingUploadTimeout": {
                return this.getOrCreateConfiguration(target).getStreamingUploadTimeout();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "useawskms": 
            case "useAwsKMS": {
                return this.getOrCreateConfiguration(target).isUseAwsKMS();
            }
            case "usecustomerkey": 
            case "useCustomerKey": {
                return this.getOrCreateConfiguration(target).isUseCustomerKey();
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseDefaultCredentialsProvider();
            }
            case "useprofilecredentialsprovider": 
            case "useProfileCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseProfileCredentialsProvider();
            }
            case "usesses3": 
            case "useSSES3": {
                return this.getOrCreateConfiguration(target).isUseSSES3();
            }
        }
        return null;
    }
}

