/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.redshift.data;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Component;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Configuration;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Constants;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Producer;
import org.apache.camel.component.aws2.redshift.data.client.RedshiftData2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;

@UriEndpoint(firstVersion="4.1.0", scheme="aws2-redshift-data", title="AWS RedshiftData", syntax="aws2-redshift-data:label", producerOnly=true, category={Category.CLOUD, Category.SERVERLESS, Category.DATABASE, Category.BIGDATA}, headersClass=RedshiftData2Constants.class)
public class RedshiftData2Endpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private RedshiftDataClient awsRedshiftDataClient;
    @UriParam
    private RedshiftData2Configuration configuration;

    public RedshiftData2Endpoint(String uri, Component component, RedshiftData2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public RedshiftData2Component getComponent() {
        return (RedshiftData2Component)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new RedshiftData2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsRedshiftDataClient = this.configuration.getAwsRedshiftDataClient() != null ? this.configuration.getAwsRedshiftDataClient() : RedshiftData2ClientFactory.getRedshiftDataClient(this.configuration).getRedshiftDataClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAwsRedshiftDataClient()) && this.awsRedshiftDataClient != null) {
            this.awsRedshiftDataClient.close();
        }
        super.doStop();
    }

    public RedshiftData2Configuration getConfiguration() {
        return this.configuration;
    }

    public RedshiftDataClient getAwsRedshiftDataClient() {
        return this.awsRedshiftDataClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "redshift";
    }
}

