/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.msk.MSK2Component;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Constants;
import org.apache.camel.component.aws2.msk.MSK2Producer;
import org.apache.camel.component.aws2.msk.client.MSK2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.kafka.KafkaClient;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-msk", title="AWS Managed Streaming for Apache Kafka (MSK)", syntax="aws2-msk:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=MSK2Constants.class)
public class MSK2Endpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private KafkaClient mskClient;
    @UriParam
    private MSK2Configuration configuration;

    public MSK2Endpoint(String uri, Component component, MSK2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new MSK2Producer((Endpoint)this);
    }

    public MSK2Component getComponent() {
        return (MSK2Component)super.getComponent();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.mskClient = this.configuration.getMskClient() != null ? this.configuration.getMskClient() : MSK2ClientFactory.getKafkaClient(this.configuration).getKafkaClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getMskClient()) && this.mskClient != null) {
            this.mskClient.close();
        }
        super.doStop();
    }

    public MSK2Configuration getConfiguration() {
        return this.configuration;
    }

    public KafkaClient getMskClient() {
        return this.mskClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "msk";
    }
}

