/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.msk.MSK2Component;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kafka.KafkaClient;

public class MSK2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private MSK2Configuration getOrCreateConfiguration(MSK2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MSK2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MSK2Component target = (MSK2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)MSK2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((MSK2Configuration)MSK2ComponentConfigurer.property((CamelContext)camelContext, MSK2Configuration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mskclient": 
            case "mskClient": {
                this.getOrCreateConfiguration(target).setMskClient((KafkaClient)MSK2ComponentConfigurer.property((CamelContext)camelContext, KafkaClient.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((MSK2Operations)((Object)MSK2ComponentConfigurer.property((CamelContext)camelContext, MSK2Operations.class, (Object)value)));
                return true;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                this.getOrCreateConfiguration(target).setOverrideEndpoint((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                this.getOrCreateConfiguration(target).setPojoRequest((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)MSK2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)MSK2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)MSK2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)MSK2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)MSK2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                this.getOrCreateConfiguration(target).setTrustAllCertificates((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                this.getOrCreateConfiguration(target).setUriEndpointOverride((String)MSK2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                this.getOrCreateConfiguration(target).setUseDefaultCredentialsProvider((Boolean)MSK2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"mskClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return MSK2Configuration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "mskclient": 
            case "mskClient": {
                return KafkaClient.class;
            }
            case "operation": {
                return MSK2Operations.class;
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return Boolean.TYPE;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return Protocol.class;
            }
            case "region": {
                return String.class;
            }
            case "secretkey": 
            case "secretKey": {
                return String.class;
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return Boolean.TYPE;
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return String.class;
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MSK2Component target = (MSK2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mskclient": 
            case "mskClient": {
                return this.getOrCreateConfiguration(target).getMskClient();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "overrideendpoint": 
            case "overrideEndpoint": {
                return this.getOrCreateConfiguration(target).isOverrideEndpoint();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return this.getOrCreateConfiguration(target).isPojoRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "trustallcertificates": 
            case "trustAllCertificates": {
                return this.getOrCreateConfiguration(target).isTrustAllCertificates();
            }
            case "uriendpointoverride": 
            case "uriEndpointOverride": {
                return this.getOrCreateConfiguration(target).getUriEndpointOverride();
            }
            case "usedefaultcredentialsprovider": 
            case "useDefaultCredentialsProvider": {
                return this.getOrCreateConfiguration(target).isUseDefaultCredentialsProvider();
            }
        }
        return null;
    }
}

