/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Map;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;

public class MQ2ClientHealthCheck
extends AbstractHealthCheck {
    private final MQ2Endpoint mq2Endpoint;

    public MQ2ClientHealthCheck(MQ2Endpoint mq2Endpoint, String clientId) {
        super("camel", "aws2-mq-client-" + clientId);
        this.mq2Endpoint = mq2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        MQ2Configuration configuration = this.mq2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !MqClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            MqClient client = this.mq2Endpoint.getAmazonMqClient();
            client.listBrokers((ListBrokersRequest)ListBrokersRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

