/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.io.Closeable;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.component.aws2.kinesis.KinesisConnection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.IOHelper;

@Component(value="aws2-kinesis")
public class Kinesis2Component
extends HealthCheckComponent {
    @Metadata
    private Kinesis2Configuration configuration = new Kinesis2Configuration();
    private KinesisConnection connection = new KinesisConnection();

    public Kinesis2Component() {
        this(null);
    }

    public Kinesis2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Kinesis2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Kinesis2Configuration();
        configuration.setStreamName(remaining);
        Kinesis2Endpoint endpoint = new Kinesis2Endpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider() || configuration.isUseProfileCredentialsProvider() || configuration.isUseSessionCredentials() || configuration.getAmazonKinesisClient() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, AmazonKinesisClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Kinesis2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Kinesis2Configuration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        this.connection.setKinesisClient(this.configuration.getAmazonKinesisClient());
    }

    protected void doStop() throws Exception {
        IOHelper.close((Closeable)this.connection);
    }

    public KinesisConnection getConnection() {
        return this.connection;
    }
}

