/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.consumer;

import org.apache.camel.component.aws2.kinesis.consumer.KinesisOffset;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeStrategyConfiguration;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="kinesis-resume-strategy")
public class KinesisResumeStrategy
implements ResumeStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisResumeStrategy.class);
    private ResumeStrategyConfiguration configuration = KinesisResumeStrategyConfiguration.builder().build();
    private ResumeCache resumeCache;
    private ResumeAdapter adapter;

    public void start() {
        LOG.info("start");
        this.resumeCache = this.configuration.getResumeCache();
    }

    public void stop() {
        LOG.info("stop");
    }

    public void setAdapter(ResumeAdapter adapter) {
        this.adapter = adapter;
    }

    public ResumeAdapter getAdapter() {
        return this.adapter;
    }

    public <T extends Resumable> void updateLastOffset(T offset) {
        this.resumeCache.add((Object)offset.getOffsetKey().getValue().toString(), (Object)new KinesisOffset((String)offset.getLastOffset().getValue(String.class)));
    }

    public <T extends Resumable> void updateLastOffset(T offset, ResumeStrategy.UpdateCallBack updateCallBack) {
        throw new UnsupportedOperationException();
    }

    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offsetValue) {
        throw new UnsupportedOperationException();
    }

    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offset, ResumeStrategy.UpdateCallBack updateCallBack) {
        throw new UnsupportedOperationException();
    }

    public void setResumeStrategyConfiguration(ResumeStrategyConfiguration resumeStrategyConfiguration) {
        this.configuration = resumeStrategyConfiguration;
    }

    public ResumeStrategyConfiguration getResumeStrategyConfiguration() {
        return this.configuration;
    }
}

