/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.component.aws2.kinesis.KinesisConnection;
import org.apache.camel.component.aws2.kinesis.ReachedClosedStatusException;
import org.apache.camel.component.aws2.kinesis.consumer.KinesisResumeAction;
import org.apache.camel.resume.ResumeAction;
import org.apache.camel.resume.ResumeActionAware;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class Kinesis2Consumer
extends ScheduledBatchPollingConsumer
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(Kinesis2Consumer.class);
    private KinesisConnection connection;
    private ResumeStrategy resumeStrategy;
    private final Map<String, String> currentShardIterators = new HashMap<String, String>();
    private final Set<String> warnLogged = new HashSet<String>();
    private volatile List<Shard> currentShardList = List.of();
    private static final String SHARD_MONITOR_EXECUTOR_NAME = "Kinesis_shard_monitor";
    private ScheduledExecutorService shardMonitorExecutor;

    public Kinesis2Consumer(Kinesis2Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public KinesisConnection getConnection() {
        return this.connection;
    }

    public void setConnection(KinesisConnection connection) {
        this.connection = connection;
    }

    public boolean isShardClosed(String shardId) {
        return this.currentShardIterators.get(shardId) == null && this.currentShardIterators.containsKey(shardId);
    }

    protected int poll() throws Exception {
        AtomicInteger processedExchangeCount = new AtomicInteger(0);
        String shardId = this.getEndpoint().getConfiguration().getShardId();
        if (!shardId.isEmpty()) {
            DescribeStreamResponse response;
            if (this.isShardClosed(shardId)) {
                this.handleClosedShard(shardId);
                return 0;
            }
            DescribeStreamRequest request = (DescribeStreamRequest)DescribeStreamRequest.builder().streamName(this.getEndpoint().getConfiguration().getStreamName()).build();
            if (this.getEndpoint().getConfiguration().isAsyncClient()) {
                try {
                    response = (DescribeStreamResponse)this.connection.getAsyncClient(this.getEndpoint()).describeStream(request).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return 0;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                response = this.connection.getClient(this.getEndpoint()).describeStream(request);
            }
            Shard shard2 = response.streamDescription().shards().stream().filter(shardItem -> shardItem.shardId().equalsIgnoreCase(this.getEndpoint().getConfiguration().getShardId())).findFirst().orElseThrow(() -> new IllegalStateException("The shard can't be found"));
            this.fetchAndPrepareRecordsForCamel(shard2, this.connection, processedExchangeCount);
        } else {
            this.getCurrentShardList().parallelStream().forEach(shard -> this.fetchAndPrepareRecordsForCamel((Shard)shard, this.connection, processedExchangeCount));
        }
        this.forceConsumerAsReady();
        return processedExchangeCount.get();
    }

    private void fetchAndPrepareRecordsForCamel(Shard shard, KinesisConnection kinesisConnection, AtomicInteger processedExchangeCount) {
        GetRecordsResponse result;
        String shardIterator;
        try {
            shardIterator = this.getShardIterator(shard, kinesisConnection);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (shardIterator == null) {
            processedExchangeCount.set(0);
            return;
        }
        GetRecordsRequest req = (GetRecordsRequest)GetRecordsRequest.builder().shardIterator(shardIterator).limit(Integer.valueOf(this.getEndpoint().getConfiguration().getMaxResultsPerRequest())).build();
        if (this.getEndpoint().getConfiguration().isAsyncClient()) {
            try {
                result = (GetRecordsResponse)kinesisConnection.getAsyncClient(this.getEndpoint()).getRecords(req).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            result = kinesisConnection.getClient(this.getEndpoint()).getRecords(req);
        }
        try {
            Queue<Exchange> exchanges = this.createExchanges(shard, result.records());
            processedExchangeCount.getAndSet(this.processBatch(CastUtils.cast(exchanges)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateShardIterator(shard, result.nextShardIterator());
    }

    private void updateShardIterator(Shard shard, String nextShardIterator) {
        this.currentShardIterators.put(shard.shardId(), nextShardIterator);
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int processedExchanges = 0;
        while (!exchanges.isEmpty()) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
            ++processedExchanges;
        }
        return processedExchanges;
    }

    public Kinesis2Endpoint getEndpoint() {
        return (Kinesis2Endpoint)super.getEndpoint();
    }

    private String getShardIterator(Shard shard, KinesisConnection kinesisConnection) throws ExecutionException, InterruptedException {
        String shardId = shard.shardId();
        if (this.currentShardIterators.get(shardId) == null) {
            GetShardIteratorResponse result;
            if (this.currentShardIterators.containsKey(shardId)) {
                this.handleClosedShard(shardId);
                return null;
            }
            GetShardIteratorRequest.Builder request = GetShardIteratorRequest.builder().streamName(this.getEndpoint().getConfiguration().getStreamName()).shardId(shardId).shardIteratorType(this.getEndpoint().getConfiguration().getIteratorType());
            if (this.hasSequenceNumber()) {
                request.startingSequenceNumber(this.getEndpoint().getConfiguration().getSequenceNumber());
            }
            this.resume(shardId, request);
            if (this.getEndpoint().getConfiguration().isAsyncClient()) {
                try {
                    result = (GetShardIteratorResponse)kinesisConnection.getAsyncClient(this.getEndpoint()).getShardIterator((GetShardIteratorRequest)request.build()).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                result = kinesisConnection.getClient(this.getEndpoint()).getShardIterator((GetShardIteratorRequest)request.build());
            }
            this.currentShardIterators.put(shardId, result.shardIterator());
            LOG.debug("Obtained new ShardIterator {} for shard {} on stream {}", new Object[]{result.shardIterator(), shardId, this.getEndpoint().getConfiguration().getStreamName()});
        }
        return this.currentShardIterators.get(shardId);
    }

    private void handleClosedShard(String shardId) {
        switch (this.getEndpoint().getConfiguration().getShardClosed()) {
            case ignore: {
                if (!this.warnLogged.add(shardId)) break;
                LOG.warn("The shard with id={} on stream {} reached CLOSE status", (Object)shardId, (Object)this.getEndpoint().getConfiguration().getStreamName());
                break;
            }
            case silent: {
                break;
            }
            case fail: {
                LOG.info("The shard with id={} on stream {} reached CLOSE status", (Object)shardId, (Object)this.getEndpoint().getConfiguration().getStreamName());
                throw new IllegalStateException(new ReachedClosedStatusException(this.getEndpoint().getConfiguration().getStreamName(), shardId));
            }
            default: {
                throw new IllegalArgumentException("Unsupported shard closed strategy");
            }
        }
    }

    private void resume(String shardId, GetShardIteratorRequest.Builder req) {
        if (this.resumeStrategy == null) {
            return;
        }
        ResumeActionAware adapter = (ResumeActionAware)this.resumeStrategy.getAdapter(ResumeActionAware.class);
        if (adapter == null) {
            LOG.warn("There is a resume strategy setup, but no adapter configured or the type is incorrect");
            return;
        }
        KinesisResumeAction action = this.resolveResumeAction(shardId, req);
        adapter.setResumeAction((ResumeAction)action);
        adapter.resume();
    }

    private KinesisResumeAction resolveResumeAction(String shardId, GetShardIteratorRequest.Builder req) {
        KinesisResumeAction action = (KinesisResumeAction)this.getEndpoint().getCamelContext().getRegistry().lookupByNameAndType("CamelKinesisDbResumeAction", KinesisResumeAction.class);
        if (action == null) {
            action = new KinesisResumeAction(req);
        } else {
            action.setBuilder(req);
        }
        action.setShardId(shardId);
        action.setStreamName(this.getEndpoint().getConfiguration().getStreamName());
        return action;
    }

    private Queue<Exchange> createExchanges(Shard shard, List<Record> records) {
        ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
        for (Record dataRecord : records) {
            exchanges.add(this.createExchange(shard, dataRecord));
        }
        return exchanges;
    }

    protected Exchange createExchange(Shard shard, Record dataRecord) {
        LOG.debug("Received Kinesis record with partition_key={}", (Object)dataRecord.partitionKey());
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setBody((Object)dataRecord.data().asByteArray());
        exchange.getIn().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)dataRecord.approximateArrivalTimestamp());
        exchange.getIn().setHeader("CamelAwsKinesisPartitionKey", (Object)dataRecord.partitionKey());
        exchange.getIn().setHeader("CamelAwsKinesisSequenceNumber", (Object)dataRecord.sequenceNumber());
        exchange.getIn().setHeader("CamelAwsKinesisShardId", (Object)shard.shardId());
        if (dataRecord.approximateArrivalTimestamp() != null) {
            long ts = dataRecord.approximateArrivalTimestamp().getEpochSecond() * 1000L;
            exchange.getIn().setHeader("CamelMessageTimestamp", (Object)ts);
        }
        return exchange;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    private boolean hasSequenceNumber() {
        return !this.getEndpoint().getConfiguration().getSequenceNumber().isEmpty() && (this.getEndpoint().getConfiguration().getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.getEndpoint().getConfiguration().getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER));
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.connection, (String)"connection", (Object)((Object)this));
        this.shardMonitorExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, SHARD_MONITOR_EXECUTOR_NAME);
        this.shardMonitorExecutor.scheduleAtFixedRate(new ShardMonitor(), 0L, this.getConfiguration().getShardMonitorInterval(), TimeUnit.MILLISECONDS);
        if (this.resumeStrategy != null) {
            this.resumeStrategy.loadCache();
        }
    }

    protected void doStop() throws Exception {
        if (this.shardMonitorExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.shardMonitorExecutor);
            this.shardMonitorExecutor = null;
        }
        super.doStop();
    }

    protected Kinesis2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected List<Shard> getCurrentShardList() {
        return this.currentShardList;
    }

    private void setCurrentShardList(List<Shard> latestShardList) {
        this.currentShardList = List.copyOf(latestShardList);
    }

    private class ShardMonitor
    implements Runnable {
        private ShardMonitor() {
        }

        @Override
        public void run() {
            try {
                List<Shard> latestShardList = this.getShardList(Kinesis2Consumer.this.connection);
                if (latestShardList != null) {
                    Kinesis2Consumer.this.setCurrentShardList(latestShardList);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception getting latest shard list", (Throwable)e);
            }
        }

        private List<Shard> getShardList(KinesisConnection kinesisConnection) {
            List shardList;
            ListShardsRequest request = (ListShardsRequest)ListShardsRequest.builder().streamName(Kinesis2Consumer.this.getEndpoint().getConfiguration().getStreamName()).build();
            if (Kinesis2Consumer.this.getEndpoint().getConfiguration().isAsyncClient()) {
                try {
                    shardList = ((ListShardsResponse)kinesisConnection.getAsyncClient(Kinesis2Consumer.this.getEndpoint()).listShards(request).get()).shards();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                shardList = kinesisConnection.getClient(Kinesis2Consumer.this.getEndpoint()).listShards(request).shards();
            }
            return shardList;
        }
    }
}

