/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Converter;
import software.amazon.awssdk.services.kinesis.model.Record;

@Converter(generateLoader=true, ignoreOnLoadError=true)
public final class RecordStringConverter {
    private RecordStringConverter() {
    }

    @Converter
    public static String toString(Record dataRecord) {
        Charset charset = StandardCharsets.UTF_8;
        ByteBuffer buffer = dataRecord.data().asByteBuffer();
        if (buffer.hasArray()) {
            byte[] bytes = dataRecord.data().asByteArray();
            return new String(bytes, charset);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, charset);
    }
}

