/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose.client;

import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.client.KinesisFirehoseInternalClient;
import org.apache.camel.component.aws2.firehose.client.impl.KinesisFirehoseClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.firehose.client.impl.KinesisFirehoseClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.firehose.client.impl.KinesisFirehoseClientStandardImpl;

public final class KinesisFirehoseClientFactory {
    private KinesisFirehoseClientFactory() {
    }

    public static KinesisFirehoseInternalClient getKinesisFirehoseClient(KinesisFirehose2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new KinesisFirehoseClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new KinesisFirehoseClientIAMProfileOptimizedImpl(configuration);
        }
        return new KinesisFirehoseClientStandardImpl(configuration);
    }
}

